define(['jquery', 'cla_highcharts'], function($, Highcharts)
{
	var ICDashboardDashboard = function(target, chartType, data, showDataLabels, colours)
	{
		this.target = target;
		this.chartType = chartType;
		this.data = data;
		this.showDataLabels = showDataLabels;
		this.colours = colours;
	};

	ICDashboardDashboard.prototype.Show = function(animate)
	{
		// Check if the chart is supposed to be drawn and bail early if not
		$target = $('#' + this.target);
		if ($target.length === 0)
			return;

		var chart = new Highcharts.Chart({
			chart: {
				renderTo: this.target
			},
			title: {
				text: ""
			},
			plotOptions: {
				pie: {
					allowPointSelect: true,
					cursor: 'pointer',
					dataLabels: {
						format: '<b>{point.name}</b>: {point.percentage:.1f} %',
						style: {
							color: (Highcharts.theme && Highcharts.theme.contrastTextColor) || 'black'
						}
					}
				},
				column: {
					colorByPoint: true,
					minPointLength: 5
				},
				series: {
					animation: animate,
					point: {
						events: {
							click: function (point) {
								if (point.point.options.link !== '')
									window.open(point.point.options.link, '_blank');
							}
						}
					}
				}
			},
			yAxis: {
				minTickInterval: 1,
				title: {
					text: null
				}
			},
			xAxis: {
				labels: {
					enabled: false
				}
			},
			series: [{
				type: this.chartType,
				data: this.data,
				showInLegend: false,
				dataLabels: {
					enabled: this.showDataLabels
				}
			}],
			tooltip: {
				formatter: function ()
				{
					if (this.point.name.length > 0)
						return this.point.name + ': ' + this.point.y;
					else
						return 'No data';
				}
			},
			colors: this.colours
		});
	};

	ICDashboardDashboard.prototype.Init = function()
	{
		var target = $('#' + this.target);

		var isPages = $('.grid-stack').length > 0;

		var self = this;
		setTimeout(function()
		{
			if (isPages)
                self.AdjustDashboardSize(target[0].closest('.tile-infocapture-component'));

			self.Show(true);
		}, 300);

		if (isPages)
		{
			var tile = target.closest('.js-tile');
			tile.off('pages-tile-resize pages-tile-add');
			tile.on('pages-tile-resize pages-tile-add', function(event, element)
			{
				// The size of the container will not be fixed for a while while it snaps to the grid
				// so delay the layout
				setTimeout(function()
				{
					self.AdjustDashboardSize(event.target);
					self.Show(false);
				}, 300);
			});
		}
	};

	ICDashboardDashboard.prototype.AdjustDashboardSize = function(element)
	{
	    var $element = $(element);
		var container = $element.find('.js-tile-body-container');
		if (container.length === 0)
			container = $element.closest('.js-tile-body-container');
		if (container.length > 0)
		{
            var height = $element.find('.hide-header').length > 0 ? $element.outerHeight() : $element.outerHeight() - 47;
            var descHeight = container.find('.js-description-container').outerHeight() || 0;
            var tableHeight = container.find('.chart-table').outerHeight() || 0;
            var dataInfoHeight = container.find('.ic-dashboard-data-info').outerHeight() || 0;

            var chartHeight = height - 31 - dataInfoHeight - descHeight - tableHeight - 1;

			container.find('.chart-container').height(chartHeight);
		}
	};

	return ICDashboardDashboard;
});
