define(['jquery'], function($)
{
	var ICList = function()
	{
		this.postfix = '';
		this.index = '';
	};

	ICList.prototype.ready = function(index, style)
	{
		this.postfix = '_' + index;
		this.index = index;

		$('#js-list-show-grid' + this.postfix).on('click', this.clickToggleIcon.bind(this));
		$('#js-list-show-list' + this.postfix).on('click', this.clickToggleList.bind(this));
		$('#searchIC' + this.postfix).on('keyup', this.search.bind(this));

		// Use required style, retrieve stored style, or default to icons
		if (style === false)
		{
			var stored = localStorage.getItem("view" + this.postfix) || 'cards--grid';
			var regex = stored.match(/cards--(.{4})/);
			var classType = regex[1] === 'null' ? 'grid' : regex[1];
		} else
		{
			classType = style;
		}

		this.toggleView(classType);
	};

	ICList.prototype.clickToggleIcon = function()
	{
		this.toggleView('grid');
		return false;
	};

	ICList.prototype.clickToggleList = function()
	{
		this.toggleView('list');
		return false;
	};

	ICList.prototype.toggleView = function(view)
	{
		const projectList = $('#projectList' + this.postfix),
			alt = view === 'grid' ? 'cards-list' : 'pages-card-grid pages-card-grid-large',
			className = view === 'grid' ? 'pages-card-grid pages-card-grid-large' : 'cards-list';

		localStorage.setItem("view" + this.postfix, 'cards-' + view);

		projectList.addClass(className).removeClass(alt);

		$('#js-list-show-' + view + this.postfix).addClass('active').siblings().removeClass('active');

	};


	ICList.prototype.search = function() {
		var search = $('#searchIC' + this.postfix);
		var term = search.val();

		var items = $('.card--' + this.index);

		items.each(function () {
			var $item = $(this);
			var check = $item.filter(function () {
				return $(this).text().toLowerCase().includes(term.toLowerCase());
			}).length >= 1;

			var className = check ? 'search-active' : 'not-search-active';
			var alt = check ? 'not-search-active' : 'search-active';

			$(this).parent().addClass(className).removeClass(alt);
		});

		// reset highlighted results if no filter term is empty
		if(term.length === 0) {
			items.removeClass('search-active').removeClass('not-search-active');
		}
	};

	return ICList;
});
