<?php
$_db_migration_to = '05.01'; // 3.0.0
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('01_Migrate_to_05.01.php', <<<'DB_UPDATE_FILE'
<?php

use Claromentis\Core\Services;

/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

// THere must be a proper way to retrieve this.
$class_key = 'icdashboard.dashboard';

$sql = 'SELECT id FROM pages_tile WHERE class_key eq:str:class_key';
$res = $db->query($sql, $class_key);

if ($res->hasData()) {

    while ($tile = $res->fetchArray()) {

        // Retrieve all of the settings for the tile. We retrieve them in reverse order
		// so we process status_type before statusdisplay or statusgroup display.
		$sql = "SELECT name, value FROM pages_tile_option WHERE tile_id eq:int:id ORDER BY name DESC";
		$res2 = $db->query($sql, $tile['id']);

		$status_type = 'default_field_status_names';
		$show_title = true;

		$new_values = [
			'title' => '',
			'data_source_field' => 'default_field_status_names',
			'data_source_field_value' => null,
			'data_filter_field' => 'default_field_status_names',
			'data_filter_field_value' => null,
			'data_period' => 1,
			'year' => 1,
			'month' => 1,
			'week' => 1,
		];

		while ($record = $res2->fetchArray()) {

			switch ($record['name']) {

				case 'project':
				case 'chart':

					$new_values[$record['name']] = $record['value'];

					break;

				case 'show':

					$all_values = ['chart', 'description', 'stage'];
					$old_values = explode(',', $record['value']);

					foreach ($all_values as $value) {
						if (!in_array($value, $old_values)) {
							if ($value == 'stage') {
								$value = 'data_table';
							}

							$new_values['show_' . $value] = 0;
						}
					}

					if ($old_values && !in_array('title', $old_values)) {
						$show_title = false;
					}

					break;

				case 'status_type':

					if ($record['value'] == 1) {
						$new_values['data_source_field'] = $status_type = 'default_field_status_names';
					} else {
						$new_values['data_source_field'] = $status_type = 'default_field_status_groups';
					}

					break;

				case 'statusdisplay':

					// We need to know what status_type is before we can know whether to record
					// a value for data_source_field_value.
					if ($status_type == 'default_field_status_names') {

						if ($record['value'] == -1) {
							$record['value'] = null;
						}

						$new_values['data_source_field_value'] = $record['value'];
					}

					break;

				case 'statusgroupdisplay':

					// We need to know what status_type is before we can know whether to record
					// a value for data_source_field_value.
					if ($status_type == 'default_field_status_groups') {

						if ($record['value'] == -1) {
							$record['value'] = null;
						}

						$new_values['data_source_field_value'] = $record['value'];
					}

					break;
			}
		}

		$sql = "DELETE FROM pages_tile_option WHERE tile_id eq:int:id";
		$res2 = $db->query($sql, $tile['id']);

		// The project should always exist.
		if ($show_title && isset($new_values['project'])) {
			$sql = "SELECT name FROM hd_project WHERE id = " . $new_values['project'];
			$res3 = $db->query($sql);

			$project_name = $res3->fetchArray();

			if ($project_name['name']) {
				$new_values['title'] = $project_name['name'];
			}
		} else {
			$new_values['title'] = null;
		}

		foreach($new_values as $name => $value) {
			$sql = "INSERT INTO pages_tile_option (tile_id, name, value) VALUES (int:id, str:name, str:value)";
			$res2 = $db->query($sql, $tile['id'], $name, $value);
		}
	}

}


DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('05.01');
