<?php
$_db_migration_to = '02.01';
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('02_knowledgebase_2_0.php', <<<'DB_UPDATE_FILE'
<?php
/*
 * Alter Existing kb_category table
 */

$DROP_TABLES = TRUE;

$db->AddColumn("kb_article", "cover_filename", "VARCHAR(255)");
$db->AddColumn("kb_article", "cover_filesize", "INT NOT_NULL DEFAULT 0");
$db->AddColumn("kb_article", "is_endorsed", "INT NOT_NULL DEFAULT 0");
$db->AddColumn("kb_article", "endorsed_by", "INT");
$db->AddColumn("kb_article", "endorsed_date", "INT_DATE");

$db->AddColumn("kb_category", "description", "CLOB");
$db->AddColumn("kb_category", "parent_id", "INT NOT_NULL DEFAULT 0");
$db->AddColumn("kb_category", "only_experts_answer", "INT NOT_NULL DEFAULT 0");

$db->CreateTable('kb_category_expert',array(
    'id'                        => 'IDENTITY',
    'category_id'				=> 'INT NOT_NULL DEFAULT 0',
    'user_id'    	            => 'INT NOT_NULL DEFAULT 0'
),$DROP_TABLES);

$db->CreateTable('kb_question', array(
	'id'			=> 'IDENTITY',
	'category_id'   => 'INT NOT_NULL',
 	'title'			=> 'VARCHAR(255)',
 	'question_text'	=> 'CLOB',
 	'is_archived'	=> 'INT NOT_NULL DEFAULT 0',
 	'created_by'    => 'INT NOT_NULL DEFAULT 0',
    'created_date'	=> 'INT_DATE',
    'modified_by'	=> 'INT NOT_NULL DEFAULT 0',
    'modified_date'	=> 'INT_DATE',
), $DROP_TABLES);

DB_UPDATE_FILE
);


$migrations->Run('03_enable_commenting_2_0.php', <<<'DB_UPDATE_FILE'
<?php
//Enable commenting in articles
$db->AddColumn("kb_article", "enable_comments", "INT NOT_NULL DEFAULT 0");
DB_UPDATE_FILE
);


$migrations->Run('04_articlestatus_2_0.php', <<<'DB_UPDATE_FILE'
<?php
//Create article status
$db->AddColumn("kb_article", "status", "INT NOT_NULL DEFAULT 0");
DB_UPDATE_FILE
);


$migrations->Run('05_embed_video_2_0.php', <<<'DB_UPDATE_FILE'
<?php
//Embed Video
$db->AddColumn("kb_article", "embed_video", "VARCHAR(500)");
DB_UPDATE_FILE
);


$migrations->Run('07_convert_to_2.0.php', <<<'DB_UPDATE_FILE'
<?php
echo "Migrating DB structure from KB pre 2.0 into KB 2.0\n";

$res = $db->query("SELECT article_id, count(article_id) as count FROM kb_category_article GROUP BY article_id HAVING count(article_id) > 1");

$arr = array();
while ($r = $res->FetchRow())
{
	$arr[] = $r[0];
}
echo "Category cleaning process started...\n";
echo "Number of articles with multiple categories: ".count($arr)."\n";

$db->DisableTokenCheck();
foreach ($arr as $article_id)
{
	$res1 = $db->query("SELECT id FROM kb_category_article WHERE article_id = int:article_id ORDER BY id", $article_id);
	$arr1 = array();
	$count = 0;
	while ($r = $res1->FetchRow())
	{
		$count++;
		//dont delete first one!
		if($count == 1) continue;

		$db->query("DELETE FROM kb_category_article WHERE id = int:id", $r[0]);
	}
}
$db->EnableTokenCheck();

echo "Category cleaning process finished\n\n";

echo "Status migration process\n";
echo "All hidden articles will be set to ARCHIVED\n";

$db->DisableTokenCheck();
$db->query("UPDATE kb_article SET enable_comments = 1"); //enable comments for all articles
$db->query("UPDATE kb_article SET status = 1"); //set ti published
$db->query("UPDATE kb_article SET status = 2 WHERE hide_article = 1"); //Set to archived
$db->EnableTokenCheck();

echo "Status migration process finished\n\n";
DB_UPDATE_FILE
);



$migrations->Run('08_create_data_folders.php', <<<'DB_UPDATE_FILE'
<?php
global $DATA_DIR;
if (!is_dir("$DATA_DIR/knowledgebase"))
	mkdir("$DATA_DIR/knowledgebase", 0777);

if (!is_dir("$DATA_DIR/knowledgebase/article_covers"))
	mkdir("$DATA_DIR/knowledgebase/article_covers", 0777);


global $APPDATA;
if (!is_dir("$APPDATA/knowledgebase"))
	mkdir("$APPDATA/knowledgebase", 0777);

if (!is_dir("$APPDATA/knowledgebase/images"))
	mkdir("$APPDATA/knowledgebase/images", 0777);

DB_UPDATE_FILE
);


$migrations->Run('09_add_innovate_questions.php', <<<'DB_UPDATE_FILE'
<?php
$innovate_config = $migrations->GetConfigEditor('innovate');
$innovate_config->AddText('$cfg_aggregation_classes["question"] = "KBQuestion";');

DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('02.01');
