define([
	'jquery',
	"imports-loader?$=jquery!../../../../node_modules/owl.carousel/dist/owl.carousel.min.js",
	"../../../../node_modules/owl.carousel/dist/assets/owl.carousel.css",
	"../../../../node_modules/owl.carousel/dist/assets/owl.theme.default.css"
], function($) {


  var Knowledgebase = function ($instance) {
    this.$container = $instance.find('.js-tile-body-container');
    this.init();
  };

  Knowledgebase.prototype.init = function() {
    var owl = this.$container.find(".owl-carousel");
    owl.owlCarousel({
	  responsive: {},
	  autoplay: true,
	  autoplaySpeed: 300,
	  autoplayHoverPause: true,
	  autoplayTimeout: 10000,
	  loop: true,
	  dots: true,
	  dotsSpeed: 400,
	  nav: false,
	  lazyLoad: true,
	  lazyLoadEager: 2,
	  items:1,
	  margin: 0

	    /*singleItem: true,
	    autoWidth: true,
	    addClassActive: true,*/
    });

	  this.calcDisplaySize();

    var self = this;

	// re-init when Pages starts up
	$('body').on('pages-started', function() {
	  self.calcDisplaySize();
	});

	// Listen to Pages events to re-init when a tile is resized
	owl.closest('.js-tile').on('pages-tile-resize', function(event, element) {
	  setTimeout(function() {
        var data = owl.data('owl.carousel');
        if (typeof data !== 'undefined')
          data.refresh();

		  self.calcDisplaySize();
	  }, 300);
	});
  };

  Knowledgebase.prototype.calcDisplaySize = function() {

    var container = this.$container;
    if (container.length > 0) {
      var fullHeight = container.height();
      container.find('.slider-kb-wrapper .owl-item').height(fullHeight);
    }
  };

  return Knowledgebase;
});
