Knowledge Base
=========

Description
----
The Knowledge Base application provides organisations with a centralised
collaborative area where information can be created, securely stored, retrieved
and shared with intranet users or groups.

Installation
----

Add `"claromentis/knowledgebase": "*"` to modules.json and run `./clc resolve`

For manual installation:

1. Clone this repository into the **web/intranet/knowledgebase** directory
2. Run:

```sh
./clc app:install knowledgebase
```

To upgrade from a previous version of Knowledge Base, run:

```sh
./clc app:upgrade knowledgebase
```

Components
=========

Recent Articles Component
----

```html
<!-- Recent Articles Component : usage example -->
<component class="\Claromentis\Knowledgebase\UI\RecentArticles">
```

Attributes:

* limit - [int] number of articles to return
* category_ids - [int or int,int,...] show articles in specified category
* endorsed_only - [int][1 or 0] show only endorsed articles
* show_category - [int][1 or 0] (optional) display the article category (default 1)
* show_date - [int][1 or 0] (optional) display the article creation date (default 1)
* show_thumbnail - [int][1 or 0] (optional) display thumbnail of article image (default 1)
* show_control - [int][1 or 0] (optional) display footer controls (add article) (default 0)
* order_by - [string] ['title', 'created_date' or most_popular] (optional) sorting method for articles (default 'created_date')

```html
<!-- Recent Articles Component : usage example with attributes -->
<component class="\Claromentis\Knowledgebase\UI\RecentArticles" limit="10" category_ids="1,2,3" endorsed_only="1" show_date="1" show_category="1" show_thumbnail="0" show_control="0" order_by="created_date">
```

Recent Questions Component
----

```html
<!-- Recent Questions Component : usage example -->
<component class="\Claromentis\Knowledgebase\UI\RecentQuestions">
```

Attributes:

* limit - [int] number of questions to return
* category_ids - [int or int,int,...] show questions in specified category
* show_username - [int][1 or 0] (optional) Show name of user who asked the question (default 1)
* show_thumbnail - [int][1 or 0] (optional) Show thumbnail profile image of user who asked the question (default 1)
* show_username - [int][1 or 0] (optional) Show name of user who asked the question (default 1)
* show_comments - [int][1 or 0] (optional) Show number of comments (default 1)
* show_views - [int][1 or 0] (optional) Show number of views (default 1)
* show_date - [int][1 or 0] (optional) Show question created_date (default 1)
* show_category - [int][1 or 0] (optional) Show category question was asked in (default 0)
* show_control - [int][1 or 0] (optional) Show footer control (ask question link) (default 0)
* order_by - [string] ['title' or 'created_date'] (optional) sorting method for articles (default 'created_date')
* unanswered_only - [int][1 or 0] show only unanswered questions

```html
<!-- Recent Questions Component : usage example with attributes -->
<component class="\Claromentis\Knowledgebase\UI\RecentQuestions" limit="5" category_ids="2" unanswered_only="1" show_username="1" show_thumbnail="1" show_comments="1" show_views="1" show_date="1" show_category="0" show_control="1" order_by="created_date" hide_if_empty="1" >
```
