<?php
$_db_migration_to = '02.05';
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('01_create_visit_stats_table.php', <<<'DB_UPDATE_FILE'
<?php
// kb_visit_stats table
$table_descr = array(
	'id' =>	"IDENTITY",
	'aggregation' => "INT NOT_NULL DEFAULT 0",
	'object_id' =>	"INT NOT_NULL DEFAULT 0",
	'user_id'		=>	"INT NOT_NULL DEFAULT 0",
	'visit_timestamp'=>	"INT_DATE NULL",
);

$db->CreateTable('kb_visit_stats', $table_descr, true);
$db->CreateIndex('kb_visit_stats', 'idx_object_id', 'object_id');

//Migrate data from kb_article_visit_stats to kb_visit_stats table
$db->query("INSERT INTO kb_visit_stats (aggregation, object_id, user_id, visit_timestamp) 
			SELECT 1, article_id, user_id, visit_timestamp
			FROM kb_article_visit_stats");

global $DATA_DIR;
if (!is_dir("$DATA_DIR/knowledgebase/article_covers"))
{
	mkdir("$DATA_DIR/knowledgebase/article_covers", 0777);
}
if (!is_dir("$DATA_DIR/knowledgebase/tmp"))
{
	mkdir("$DATA_DIR/knowledgebase/tmp", 0777);
}

global $APPDATA;
if (!is_dir("$APPDATA/knowledgebase/images"))
{
	mkdir("$APPDATA/knowledgebase/images", 0777);
}

DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('02.05');
