<?php
// This file contains the database schema version 17.03
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
if ($migrations->GetVersion() > 0)
	throw new Exception("The database is already initialized");
//===========================================================================================

// kb_article
$table_descr = array(
	'id'	=>	"IDENTITY",
	'status'	=>	"INT NOT_NULL DEFAULT 0",
	'category_id'	=>	"INT NULL",
	'publisher_id'	=>	"INT NULL",
	'created_by'	=>	"INT NULL",
	'created_date'	=>	"INT_DATE NULL",
	'modified_by'	=>	"INT NULL",
	'modified_date'	=>	"INT_DATE NULL",
	'cover_filename'	=>	"VARCHAR(255) NULL",
	'cover_filesize'	=>	"INT NOT_NULL DEFAULT 0",
	'enable_comments'	=>	"INT NOT_NULL DEFAULT 0",
	'embed_video'	=>	"VARCHAR_MAX NULL",
	'is_endorsed'	=>	"INT NOT_NULL DEFAULT 0",
	'endorsed_by'	=>	"INT NULL",
	'endorsed_date'	=>	"INT_DATE NULL",
);

$db->CreateTable('kb_article', $table_descr, true);
$db->CreateIndex('kb_article', 'idx_publisher_id', 'publisher_id');



// kb_article_translation
$table_descr = array(
	'id'	=>	"IDENTITY",
	'article_id'	=>	"INT NULL",
	'language'	=>	"VARCHAR(10) NULL",
	'title'	=>	"VARCHAR(255) NULL",
	'article_text'	=>	"CLOB NULL",
	'modified_by'	=>	"INT NULL",
	'modified_date'	=>	"INT_DATE NULL",
);

$db->CreateTable('kb_article_translation', $table_descr, true);
$db->CreateIndex('kb_article_translation', 'idx_article_id', 'article_id');
$db->CreateIndex('kb_article_translation', 'idx_language', 'language');



// kb_article_visit_stats
$table_descr = array(
	'id'	=>	"IDENTITY",
	'article_id'	=>	"INT NULL",
	'language'	=>	"VARCHAR(50) NULL",
	'user_id'	=>	"INT NULL",
	'visit_timestamp'	=>	"INT_DATE NULL",
);

$db->CreateTable('kb_article_visit_stats', $table_descr, true);
$db->CreateIndex('kb_article_visit_stats', 'idx_article_id', 'article_id');



// kb_category
$table_descr = array(
	'id'	=>	"IDENTITY",
	'name'	=>	"VARCHAR(255) NULL",
	'created_by'	=>	"INT NULL",
	'created_date'	=>	"INT_DATE NULL",
	'modified_by'	=>	"INT NULL",
	'modified_date'	=>	"INT_DATE NULL",
	'description'	=>	"CLOB NULL",
	'parent_id'	=>	"INT NOT_NULL DEFAULT 0",
	'only_experts_answer'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('kb_category', $table_descr, true);



// kb_category_expert
$table_descr = array(
	'id'	=>	"IDENTITY",
	'category_id'	=>	"INT NOT_NULL DEFAULT 0",
	'user_id'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('kb_category_expert', $table_descr, true);



// kb_question
$table_descr = array(
	'id'	=>	"IDENTITY",
	'category_id'	=>	"INT NOT_NULL",
	'title'	=>	"VARCHAR(255) NULL",
	'question_text'	=>	"CLOB NULL",
	'is_archived'	=>	"INT NOT_NULL DEFAULT 0",
	'created_by'	=>	"INT NOT_NULL DEFAULT 0",
	'created_date'	=>	"INT_DATE NULL",
	'modified_by'	=>	"INT NOT_NULL DEFAULT 0",
	'modified_date'	=>	"INT_DATE NULL",
);

$db->CreateTable('kb_question', $table_descr, true);



// kb_subscription
$table_descr = array(
	'object_type'	=>	"INT NOT_NULL DEFAULT 0",
	'object_id'	=>	"INT NOT_NULL DEFAULT 0",
	'user_id'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('kb_subscription', $table_descr, true);
$db->CreatePrimaryKey('kb_subscription', 'object_type', 'object_id', 'user_id');
$db->CreateIndex('kb_subscription', 'idx_object_user', 'object_type', 'user_id');
$db->CreateIndex('kb_subscription', 'idx_object_type', 'object_type');
$db->CreateIndex('kb_subscription', 'idx_user_id', 'user_id');



// kb_visit_stats
$table_descr = array(
	'id'	=>	"IDENTITY",
	'aggregation'	=>	"INT NOT_NULL DEFAULT 0",
	'object_id'	=>	"INT NOT_NULL DEFAULT 0",
	'user_id'	=>	"INT NOT_NULL DEFAULT 0",
	'visit_timestamp'	=>	"INT_DATE NULL",
);

$db->CreateTable('kb_visit_stats', $table_descr, true);
$db->CreateIndex('kb_visit_stats', 'idx_object_id', 'object_id');





//===========================================================================================
$migrations->SetVersion('17.03');
