<?php
$_db_migration_to = '05.01';
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('01_translation_table.php', <<<'DB_UPDATE_FILE'
<?php
use Claromentis\Core\DAL\Query;
use Claromentis\Core\DAL\QueryUpdate;

/**
 * @var $migrations \Claromentis\Setup\SetupFacade
 */
$db = $migrations->GetDb();

// Drop columns that are unused as of v2.0.x
$db->DropColumn('kb_article', 'publish_from');
$db->DropColumn('kb_article', 'publish_to');
$db->DropColumn('kb_article', 'hide_article');
$db->DropColumn('kb_article_group', 'var');

// Create kb_article columns in kb_article_group (to become kb_article)
$db->AddColumn('kb_article_group', 'status',          'INT NOT_NULL DEFAULT 0');
$db->AddColumn('kb_article_group', 'category_id',     'INT NULL');
$db->AddColumn('kb_article_group', 'publisher_id',    'INT NULL');
$db->AddColumn('kb_article_group', 'created_by',      'INT NULL');
$db->AddColumn('kb_article_group', 'created_date',    'INT_DATE NULL');
$db->AddColumn('kb_article_group', 'modified_by',     'INT NULL');
$db->AddColumn('kb_article_group', 'modified_date',   'INT_DATE NULL');
$db->AddColumn('kb_article_group', 'cover_filename',  'VARCHAR(255) NULL');
$db->AddColumn('kb_article_group', 'cover_filesize',  'INT NOT_NULL DEFAULT 0');
$db->AddColumn('kb_article_group', 'enable_comments', 'INT NOT_NULL DEFAULT 0');
$db->AddColumn('kb_article_group', 'embed_video',     'VARCHAR(500) NULL');
$db->AddColumn('kb_article_group', 'is_endorsed',     'INT NOT_NULL DEFAULT 0');
$db->AddColumn('kb_article_group', 'endorsed_by',     'INT NULL');
$db->AddColumn('kb_article_group', 'endorsed_date',   'INT_DATE NULL');

$db->CreateIndex('kb_article_group', 'idx_publisher_id', 'publisher_id');

// Copy data from kb_article into new kb_article_group columns (the fun part)
$articles = array();

// Self join to make sure we get the latest modified date for each article group
$result = $db->query("SELECT a.* FROM kb_article a
	JOIN (SELECT MIN(id) AS id, article_group_id, MAX(modified_date) AS modified_date
		  FROM kb_article a
		  GROUP BY article_group_id ) aa
		ON a.id = aa.id
	ORDER BY a.article_group_id, a.id");

while ($row = $result->fetchArray())
	$articles[] = $row;

// Columns to copy over
$columns = array(
	'status', 'created_by', 'created_date', 'modified_by', 'modified_date',
	'publisher_id', 'cover_filename', 'cover_filesize', 'enable_comments',
	'embed_video', 'is_endorsed', 'endorsed_by', 'endorsed_date'
);

// Copy the data
foreach ($articles as $article)
{
	$values = array(
		'int:status'          => $article['status'],
		'int:created_by'      => $article['created_by'],
		'int:created_date'    => $article['created_date'],
		'int:modified_by'     => $article['modified_by'],
		'int:publisher_id'    => $article['publisher_id'],
		'str:cover_filename'  => $article['cover_filename'],
		'int:cover_filesize'  => $article['cover_filesize'],
		'int:enable_comments' => $article['enable_comments'],
		'str:embed_video'     => $article['embed_video'],
		'int:is_endorsed'     => $article['is_endorsed'],
		'int:endorsed_by'     => $article['endorsed_by'],
		'int:endorsed_date'   => $article['endorsed_date']
	);
	
	$update = new QueryUpdate('kb_article_group', 'id eq:int:group_id', $values);
	$update->Bind('group_id', $article['article_group_id']);
	
	$db->query($update);
}

// Drop indxes on kb_article to allow for column changes
$db->DropIndex('kb_article', 'idx_article_group_id');
$db->DropIndex('kb_article', 'idx_publisher_id');

// Rename kb_article foreign key
$db->AlterColumn('kb_article', 'article_group_id', 'article_id');

// Restore the index on the renamed column
$db->CreateIndex('kb_article', 'idx_article_id', 'article_id');

// Drop the same columns from kb_article (except modified by/date)
$db->DropColumn('kb_article', 'publisher_id');
$db->DropColumn('kb_article', 'created_by');
$db->DropColumn('kb_article', 'created_date');
$db->DropColumn('kb_article', 'cover_filename');
$db->DropColumn('kb_article', 'cover_filesize');
$db->DropColumn('kb_article', 'is_endorsed');
$db->DropColumn('kb_article', 'endorsed_by');
$db->DropColumn('kb_article', 'endorsed_date');
$db->DropColumn('kb_article', 'enable_comments');
$db->DropColumn('kb_article', 'status');
$db->DropColumn('kb_article', 'embed_video');

// Clean up any kb_article_group records without a creator
$db->query('DELETE FROM kb_article_group WHERE created_by IS NULL');

// Finally, give the tables their new names
$db->RenameTable('kb_article', 'kb_article_translation');
$db->RenameTable('kb_article_group', 'kb_article');

DB_UPDATE_FILE
);


$migrations->Run('02_translation_innovate_aggregation.php', <<<'DB_UPDATE_FILE'
<?php
/**
 * @var $migrations \Claromentis\Setup\SetupFacade
 */
$innovate_config = $migrations->GetConfigEditor('innovate');
$innovate_config->AddText('$cfg_aggregation_classes["article"] = "KBArticleTranslation";');

DB_UPDATE_FILE
);


$migrations->Run('03_article_categories.php', <<<'DB_UPDATE_FILE'
<?php
/**
 * @var $migrations \Claromentis\Setup\SetupFacade
 */
$db = $migrations->GetDb();

// Fetch article and category IDs from kb_category_article, whose article_id
// field is actually pointing to translations still; we work out the right
// category_id for each article by joining onto kb_article_translation
$result = $db->query('SELECT DISTINCT at.article_id as article_id, ca.category_id
	FROM kb_category_article ca
	JOIN (SELECT MIN(id) AS id, article_id
		  FROM kb_article_translation
		  GROUP BY article_id) at
    ON ca.article_id = at.id');

$articleCategories = array();

while ($row = $result->fetchArray())
	$articleCategories[] = $row;

// Apply the category_id's we've found to the correct articles
foreach ($articleCategories as $ac)
	$db->query('UPDATE kb_article SET category_id eq:int:category ' .
		'WHERE kb_article.id eq:int:article', $ac['category_id'], $ac['article_id']);

// Drop the many-to-many table that we no longer need
$result = $db->DropTable('kb_category_article');

DB_UPDATE_FILE
);


$migrations->Run('04_cover_images.php', <<<'DB_UPDATE_FILE'
<?php
/**
 * @var $migrations \Claromentis\Setup\SetupFacade
 */
$db = $migrations->GetDb();
$data_dir = $migrations->GetDataDir();

// Rename all cover image data to match new articles instead of translations
$result = $db->query("SELECT MIN(id) id, article_id from kb_article_translation
	GROUP BY article_id");

$articles = array();

while($row = $result->fetchArray())
	$articles[$row['id']] = $row['article_id'];

$dir = $data_dir . "/knowledgebase/article_covers/";

foreach ($articles as $from => $to)
{
	if (is_file("$dir$from.dat"))
		rename("$dir$from.dat", "$dir$to.dat");
	
	if (is_file("$dir$from-thumb.dat"))
		rename("$dir$from-thumb.dat", "$dir$to-thumb.dat");
}

// Delete all .dat files that no longer match an article ID
foreach (glob($dir . '*.dat') as $path) {
	$filename = basename($path);
	preg_match('/^(\d*)/', $filename, $matches);
	
	if (!in_array($matches[1], $articles)) {
		unlink($path);
	}
}

DB_UPDATE_FILE
);


$migrations->Run('05_article_tags.php', <<<'DB_UPDATE_FILE'
<?php
/**
 * @var $migrations \Claromentis\Setup\SetupFacade
 */
$db = $migrations->GetDb();

// Point all tags that currently point to translations to their parent articles
$result = $db->query('UPDATE tags
	SET object_id = (SELECT article_id FROM kb_article_translation WHERE id = tags.object_id)
	WHERE aggregation = 110');

// Create a table to temporarily store distinct article tags
$db->CreateTable('tags_kb_article_distinct', array(
	'aggregation' => "INT NOT_NULL DEFAULT 0",
	'object_id'   => "INT NOT_NULL DEFAULT 0",
	'tag'         => "VARCHAR(100) NULL",
));

// Copy all distinct article tags into the temporary table
$db->query('INSERT INTO tags_kb_article_distinct
	SELECT DISTINCT *
	FROM tags
	WHERE aggregation = 110');

// Delete all article tags in the original table
$db->query('DELETE FROM tags WHERE aggregation = 110');

// Copy distinct tags back into original table
$db->query('INSERT INTO tags
	SELECT * FROM tags_kb_article_distinct');

// Delete the temporary table
$db->DropTable('tags_kb_article_distinct');

DB_UPDATE_FILE
);


$migrations->Run('06_translation_language_index.php', <<<'DB_UPDATE_FILE'
<?php
/**
 * @var $migrations \Claromentis\Setup\SetupFacade
 */
$db = $migrations->GetDb();

$db->AlterColumn('kb_article_translation', 'language', 'language', 'VARCHAR(10) NULL');
$db->CreateIndex('kb_article_translation', 'idx_language', 'language');

DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('05.01');
