# Knowledge Base Change Log

## 5.0.6 - 17th December 2025

- Merged upstream changes from 4.1.6

## 5.0.5 - 5th December 2025

- Merged upstream changes from 4.1.5

## 5.0.4 - 16th September 2025

- Merged upstream changes from 4.1.4

## 5.0.3 - 21st August 2025

- Merged upstream changes from 4.1.3

## 5.0.2 - 19th June 2025

### Developer notes

- Merged upstream changes from 4.1.2

## 5.0.1 - 16th June 2025

### Developer notes

- Merged upstream changes from 4.1.1

## 5.0.0 - 9th June 2025

### Improvements

- !94 BOOTY-612 Limited category length to 90 characters on Add Category input form

## 5.0.0-beta - 16th April 2025

- !88 FRAM-1040 Symfony 5 compatibility: Fixed PDF generation
- 30dcfb9e FRAM-832 FRAM-1040 FRAM-1053 BT-5174 BT-5175 Fixed PHP 8 compatibility for the Recent Articles component
- bfb1985b a90ff42b 5bdb75a1 BT-5174 BT-5175 Fixed PHP 8 compatibility for the Recent Questions component
- Merged upstream changes from 4.1.0

## 5.0.0-alpha - 14th November 2024

- FRAM-954 Claromentis 10 compatibility

## 4.1.6 - 17th December 2025

### Bug fixes

- !102 BT-5772 Fixed an error that occurred when enabling or disabling questions in the admin area

## 4.1.5 - 4th December 2025

### Improvements

- !97 KB-22 Added filter by creator and a CSV export function to articles and questions admin

## 4.1.4 - 16th September 2025

### Improvements

- !99 UIUX-930 Updated breadcrumb menu item for current page

### Bug fix

- !96 KB-23 Fixed 'Endorsed' badge label sizing in Knowledge Base articles

## 4.1.3 - 26th June 2025

### Bug fixes

- !95 BT-5395 Fixed an issue that caused a "Page Not Found" error when endorsing an article

## 4.1.2 - 19th June 2025

- Merged upstream schanged from 3.9.24

## 4.1.1 - 16th June 2025

### Improvements

- !92 KB-20 Disco 048954 Added Modified Date column to the Knowledge Base articles list
- !93 KB-21 Increased the maximum length of article and question HTML page titles

## 4.1.0 - 16th April 2025

<!-- Minor release due to new feature -->

### New features

- !90 KB-7 Disco 042362 Updated Knowledge Base articles to generate user-friendly URLs (URL slugs)

### Bug fixes

- !91 BT-5065 Fixed missing spacing in Knowledge Base archived article header

## 4.0.20 - 7th March 2025

### Improvements

- !89 UIUX-906 Updated font size for Knowledge Base articles and questions titles so they are styled as H1 headings

## 4.0.19 - 9th January 2025

### Developer notes

- Merged upstream changes from v3.9
- Database migration to increase size of embed_video column

## 4.0.18 - 12th November 2024

### Bug fixes

- !85 KB-18 Fixed styling in admin articles search result

## 4.0.17 - 18th October 2024

### Improvements

- !84 BT-4904 Added cover images to article search results

### Bug fixes

- !84 BT-4904 Fixed missing descriptions for article search results

### Developer notes

- Merged upstream changes from v3.9

## 4.0.16 - 4th September 2024

### Improvements

- !76 SRCH-18 Search results for Knowledge Base articles and questions will now display their created date and last modified date
- !82 KB-16 Adjusted article width in Knowledgebase

### Bug fixes

- !81 BT-4712 Fixed text break issues for long Knowledge Base questions & article headers

## 4.0.15 - 19th June 2024

### New features

- !74 KB-4 Added view count display for Knowledge Base articles

### Improvements

- !80 BT-4696 French localisation update
- !77 BT-4684 German localisation update
- !65 KB-3 Hide questions and question functionality in list views when questions are disabled

### Bug fixes

- !75 KB-10 Hide 'Create an Article' and 'Ask a question' button for users without article/question creation permissions

### Developer notes

- Merged upstream improvements from v3.9

## 4.0.14 - 24th April 2024

### Developer notes

- Merged upstream improvements and bug fixes from 3.9.19

## 4.0.13 - 10th April 2024

### Improvements

- !73 BT-4573 Updated category name client side validation from 90 chars to 255 chars

### Developer notes

- Merged upstream improvements and bug fixes from 3.9.18 

## 4.0.12 - 4th April 2024

### Improvements

- !67 KB-9 Centered and limited the width of content in Articles and Questions when using full width themes

### Bug fixes

- !68 BT-4525 Fixed an error that occurred when deleting an uploaded cover image before creating a new article
- !69 BT-4568 Disco 044812 Fixed an issue where viewing a Knowledge Base Article the 'Download PDF' button does not appear for users with 'View' only permissions

### Developer notes

- Merged upstream improvements and bug fixes from 3.9.16, 3.9.17

## 4.0.11 - 30th November 2023

- FRAM-946 Further fixes for data directory permissions

## 4.0.10 - 30th November 2023

- Merged upstream changes from 3.9
- cf4e046d Claromentis Core 10 compatibility

## 4.0.9 - 22nd November 2023

### Bug fixes

- !63 BT-4204 Fixed asterisk alignment issue when editing articles or questions
- !64 UIUX-862 Improved semantic headings for article and question titles
- Merged upstream changes from 3.9
  - !59 BT-4093 Disco 041822 Fixed a localization bug where the Russian and Uzbek languages would prevent category deletion

## 4.0.8 - 3rd October 2023

### Improvements

- Merged upstream changes from 3.9
  - !62 FRAM-935 Improved Knowledge Base articles statistics integration performance

### Bug fixes

- !61 BT-4130 Reduced width within question title input field

## 4.0.7 - 26th July 2023

### Bug fixes

- !60 BT-4130 Removed spacing between creator and modifier update within article
- Merged upstream changes from 3.9
  - !57 KB-1 Reimplemented infinite scrolling for articles lists and question lists

## 4.0.6 - 16th June 2023

### Improvements

- !58 BT-4079 Changed the comments sort order to show the newest comments first
- Merged upstream changes from 3.9
  - !56 KB-5 Increased maximum length of article titles from 150 to 200 characters

## 4.0.5 - 2nd February 2023

- Merged upstream changes from 3.9
  - cf6082a4 BT-3890 Fixed fatal errors caused by empty article content

## 4.0.4 - 5th January 2023

- Merged upstream changes from 3.9
  - !55 BT-3877 Fixed strict HTML sanitization in article descriptions introduced by 3.9.8; restored the ability to use `<iframe>`s in article content

## 4.0.3 - 13th December 2022

### Improvements

- Merged upstream changes from 3.9
- !52 BT-3511 Updated Pages article component slider to use the latest version of the library
- 30d92baf BOOTY-612 Set a 90 character limit to Knowledgebase categories
- FRAM-838 Added menu item registration

### Bug fixes

- 335a1bc4 4dd980db BT-3707 Fixed issue with follow button in sub categories not having any text
- 8415b79e BT-3706 Fixed issue with Knowledgebase author user picker being too small when no user has been picked
- 2a52470f BT-3720 Fixed issue with content of KB sliders being able to overflow the height of the slide when there is a long category
- 0dad6cb0 BT-3660 Set the minimum height of the Knowledgebase articles component so it doesn't cut off content when fully utilised 
- !54 BOOTY-614 Fixed issue with design of the Knowledgebase toolbars/controls not having the correct design and iconography
- 8217a7eb BT-3720 Fixed minor specificity issues which have occurred/shown up since the merging of the Slider improvements branch (BT-3511)

## 4.0.2 - 14th October 2022

* Merged upstream changes from 3.9

### Improvements

* !51 BOOTY-582 Replaced utility classes usages with Bootstrap 4 standard utility classes
* fbd95364 BT-3521 Upgraded design of Knowledgebase 'Related Information' meta data to use the new vertical mode
* FRAM-838 Implemented Composer autoloading for application constants

## 4.0.1 - 5th August 2022

### Bug fixes

* 988a8b61 BOOTY-500 Updated pages component IDs so they use the new class structure
 * BOOTY-512 Articles component
 * BOOTY-513 Questions component
* cd99ddca BOOTY-412 Updated some missed badge classes so they display correctly 
* 4b99d349 BOOTY-412 BT-3448 Fixed issues with KB article slider not displaying when a title is present and refined and refactored styling.
* e80f3d6a BOOTY-412 Fixed issues with KB slider not taking on the theme border radius correctly.

### Developer notes

* Improved error handling when exporting PDFs
* Removed global variable usage from article view controller

## 4.0.0 - 17th June 2022

* Merged upstream changes from 3.9

### Bug fixes

* 55aff825 BOOTY-412 BT-3350 Fixed overflow issue in KnowledgeBase in 'Article Title' and 'Embed Video' fields when creating/editing an article

## 4.0.0-beta - 25th February 2022

* Claromentis 9 compatibility
* 0ccdc655 0a56dc59 Improved error handling when generating Article PDF files
* 2da9cf9f FRAM-641 Enabled caching for Article cover images
* 592b5ea5 FRAM-641 Corrected mime types for Article cover image responses

## 3.9.24 - 19th June 2025

- b7244f96 RD-43 Fixed a security issue relating to question lists

## 3.9.23 - 9th January 2025

### Bug fixes

- !86 BT-5064 Fixed embed_video iframe code being truncated on new article save

## 3.9.22 - 3rd October 2024

### Improvements

- !83 KB-17 Added a confirmation dialog when leaving the edit article page with unsaved changes.

## 3.9.21 - 19th June 2024

### Bug fixes

- !78 KB-6 Resolved an issue where the Knowledge Base Advanced Search was not returning "Endorsed" articles when filtered

## 3.9.20 - 12th June 2024

### Bug fixes

- !79 BT-4611 Fixed "Add category" alignment issue in the Knowledge Base admin panel

## 3.9.19 - 24th April 2024

### Bug fixes

- !71 BT-4579 Disco 044784 Fixed an issue where links were removed from downloaded article PDF files

## 3.9.18 - 10th April 2024

### Bug fixes

- !72 BT-4573 Fixed an error when adding a new category that has name longer than 255 characters

## 3.9.17 - 4th April 2024

### Bug fixes

- !70 BT-4525 Fixed an error that occurred when deleting an uploaded cover image before creating a new article

## 3.9.16 - 30th November 2023

- FRAM-946 Further fixes for data directory permissions

## 3.9.15 - 30th November 2023

- ca2e17e7 FRAM-946 Fixed insufficient data directory permissions during installation

## 3.9.14 - 22nd November 2023

### Bug fixes

- !59 BT-4093 Disco 041822 Fixed a localization bug where the Russian and Uzbek languages would prevent category deletion

## 3.9.13 - 3rd October 2023

### Improvements

- !62 FRAM-935 Improved Knowledge Base articles statistics integration performance

## 3.9.12 - 26th July 2023

### Bug fixes

- !57 KB-1 Reimplemented infinite scrolling for articles lists and question lists

## 3.9.11 - 16th June 2023

### Improvements

- !56 KB-5 Increased maximum length of article titles from 150 to 200 characters

## 3.9.10 - 2nd February 2023

* cf6082a4 BT-3890 Fixed fatal errors caused by empty article content

## 3.9.9 - 5th January 2023

* !55 BT-3877 Fixed strict HTML sanitization in article descriptions introduced by 3.9.8; restored the ability to use `<iframe>`s in article content

## 3.9.8 - 13th December 2022

## Bug fixes

* !53 KB-2 Fixed unescaped text in article descriptions

## 3.9.7 - 8th July 2022

* !50 FRAM-841 Disco 037444 Improved performance for article cover images

## 3.9.6 - 14th June 2022

## Bug fixes

* !49 BT-3398 Fixed a bug when the user can add a question in category view when questions are disabled for that category

## 3.9.5 - 17th January 2022

### Improvements

* !48 FRAM-800 wkhtmltopdf 0.12.6 compatibility

### Developer notes

* !48 RD-31 Fixed SSRF vulnerability

## 3.9.4 - 23rd September 2021
* !46 BT-2844 Disco-34091 Fixed issue where articles with empty mandatory metadata could be saved without error

## 3.9.3 - 15th June 2021
* !45 BT-2438 BT-2439 Disco-32959 Fixed a bug searching articles by tag name (the number of searched articles was limit to 10)

## 3.9.2 - 26th November 2020
* !43 FRAM-394 Unknown query parameters are now no longer included in language selection links on edit page

## 3.9.1 - 24th November 2020
### Bug fixes
* !44 BT-2099 Fixes PHP 7.4 incompatibility when viewing questions admin page

## 3.9.0 - 16th June 2020
### Improvements
* !41 BT-1498 Remove embedded video preview from Article thumbnails.

### Breaking changes
* !41 BT-1498 Removed `popup.js` library.

## 3.8.2 - 15th May 2020

* !39 BT-1485 Fixed issue with missing localisation key.
* !40 BT-1446 Fixed subscribe/unsubscribe buttons not working

## 3.8.1 - 19th March 2020
* !30 (FRAM-341) Updated search to work with Elasticsearch 7
* !31 BT-880 Fixed HTML injection issue by replacing all legacy templates with precompiled underscore templates

## 3.7.11 - 19th March 2020
* !36 BT-349 Image was not resized and displaying cut off in KB question

## 3.6.7 - 19th March 2020
### Improvements
* !35 BT-992 Localized the display of Category names for:
    * Parent Categories.
    * Subcategories.
    * Comments Breadcrumbs.
    * Recent Articles Pages Component Options.
    * Recent Questions Pages Component Options.
### Bug fixes
* !32 BT-571 Fixed detecting the current user's language for search results

## 3.8.0 - 29th October 2019
* (CORE-801) Added support for Statistics plugin and implemented stats for article and question views and unique views.
* Added Uzbek translation
* CORE-1040
  * Added auditing of likes/unlikes on articles and questions
  * Audit log now shows object names
## 3.7.10 - 27th November 2019
* !29 BT-840 Added a "draft articles" panel to the knowledgebase frontend, to 
allow easy access to unpublished articles for users with permission to view them.
* CORE-1036 Added Hungarian translation

## 3.7.9
* Merged forward from 3.5.5, 3.6.6
  * BT-850 Fixed Article/Question sorting not applying correctly on page load

## 3.7.8
### Improvements
* !27 CORE-973 Added Component `Articles` to Category `Learning & Knowledge Base`.
* !27 CORE-973 Added Component `Questions` to Category `Learning & Knowledge Base`.
* !26 CORE-974 Added Localized Titles to the following Components:
     * Articles
     * Questions

## 3.7.7
* UIUX-613 Shortened tab titles for Articles and Questions (IID0004)
* Merged forward from 3.4.6
  * !22 UIUX-546 Fixed "View all questions" link incorrectly showing all articles.

## 3.7.6
* Merged forward bug fixes and improvements from `3.6.4`.

## 3.7.5
* !24 UIUX-560 Small fix to correct issue with inconsistent border radius' on nav items and images on the knowledge base 'Recent Articles' pages component.
* Core dependency updated to **~8.7.7** or **~8.8.1** or **>=8.9**
* !36 BT-349 Image is not resized and displaying cut off in KB question 


## 3.7.4
* !17 UIUX-499 Recent Articles component slider

## 3.7.3
* !21 UIUX-534 Added asterisk to Create Article and Create Question mandatory fields
- !23 fixed bug where localised category names were displayed incorrectly

## 3.7.2
* Merged forward Russian translations from 3.6
* !15 UIUX-131 Added ability to enlarge article and question images on click
* !15 CORE-847 Fixed article cover image upload error when Filesystem abstraction is in use
* !18 CORE-897 Fixed issue uploading a replacement Cover Image to a Knowledgebase Article.

## 3.7.1
* Countable warning fixed when viewing article. (CORE-346)

## 3.7.0
* Compatible from Claromentis 8.7
* !14 Improved the design consistency of Recent Articles & Recent Questions components when they are empty

## 3.6.6 - 21st October 2019
* Merged forward from 3.5.5
  * BT-850 Fixed Article/Question sorting not applying correctly on page load

## 3.6.5
* Merged forward from 3.4.6
  * !22 UIUX-546 Fixed "View all questions" link incorrectly showing all articles.

## 3.6.4
* !25 BT-633 Fixed Theme Background settings appearing in PDF Article downloads.
* !25 BT-633 Unsuccessful generation of Article PDF files is now relayed to the User.
* !25 BT-633 Failure to generate a PDF is now logged.

## 3.6.3
* Core dependency updated to **~8.6.9**

## 3.6.2
* Added Russian translations and twig templates

## 3.6.1
* !13 Improved terminology used when subscribing or unsubscribing from categories (Jira UIUX-259)

## 3.6.0
* Compatible from Claromentis 8.6
* Added ability to reference localisations in category name (Jira UIUX-97).

## 3.5.5
* BT-850 Fixed Article/Question sorting not applying correctly on page load

## 3.5.4
* Merged forward from 3.4.6
  * !22 UIUX-546 Fixed "View all questions" link incorrectly showing all articles.

## 3.5.3
* Core dependency updated to **~8.5.15**

## 3.5.2
* Fix enable/disable questions being accessible by non-admin users

## 3.5.1
* Enabling Localisation for Knowledge Base App Name in Admin Panel
* Changing word from Subscribe to Follow for Articles and Question (Jira UIUX-60)
* Changed subscribe/unsubscribe alerts to follow/stop following (JIra UIUX-54)
* Removing hard-coded colour for article (#21204)
* Article .pdf output now allows links. (Jira CORE-119 Disco 22129)

## 3.5.0
* Compatible from Claromentis 8.5

## 3.4.6
* !22 UIUX-546 Fixed "View all questions" link incorrectly showing all articles.

## 3.4.5
* !19 (BT-463) Altered saving of Article Text to sanitise HTML before saving.
* !26 (BT-660) Fixed images not exporting to Article PDF downloads when using a remote CDN.
* !26 (BT-660) Core dependency updated to **~8.4.17**, Core **8.3** is no longer supported.
* Disabled Advanced Search for Questions when Questions are disabled. (#446)
* Category will now pre-populate when asking from the Questions component if a single Category is selected. (#550)
* Questions will reindex when enabled/disabled. (#553)
* Questions Component will no longer allow the User to ask a question if Questions are disabled. (#554)
* Questions Component content will no longer display when questions are disabled. (#551)

## 3.4.4
* Compatible up to Claromentis 8.4
* Fixed incorrect redirects for old article IDs (#536)
* Removed breadcrumb from Articles exported to PDF (#541)
* Switched keyword searches to use fuzzy queries
* Fixed a problem where user-provided full URLs were being mangled when exporting articles to PDF

## 3.3.8
* Fixed problem where user-provided full URLS were being mangled
* Prevented javascript console error when user does not have access to sub-category (#528)

## 3.4.3
* Merged German translations from 3.3.7

## 3.4.2
* The recent articles/questions side panel is now filtered by category
* Articles whose creators have been deleted now show "deleted user" instead of empty space
* Articles now show the user who last modified them as well as the creator

## 3.3.7
* Added German translations to knowledgebase components (Disco 017837)

## 3.3.6
* Fixed German notifications related to (Disco 19964 and Disco 19917)
* Fixed a bug where changes to the very first question would not have notifications sent. No associated bug number.
* Revert "Removed malformed notification templates. (Disco 19964 and Disco 19917)"

## 3.3.5
* Removed some broken German notification translations. (Disco 19964 and Disco 19917)

## 3.4.1
* Some design fixes

## 3.4.0
* Support for indexing and searching categories in global search
* Added "share" button
* Limit page width to look better in full-screen layout
* Requires Claromentis 8.3

## 3.3.4
* Fixed detecting current user's language and showing the article in the correct language
* Added some missing German translations

## 3.3.3
* Fixed article/question comments being editable by other staff (DISCO #019049)

## 3.3.2
* More reliable files location detection for CKEditor
* Marked as compatible with Claromentis 8.3
* Fixed not working language switch on article page (#509)

## 3.3.1
* Fix document images not showing on PDF download (DISCO #018015)

## 3.3.0
* No changes

## 3.3.0-rc4
* Fixed issue with Category drop down expanding outside of window in admin

## 3.3.0-rc3
* Fixed styling issues affecting mobile devices
* Removed grey backgrounds from articles
* Fixed unescaped item text in search results
* Prevented admin panel tables stretching when containing long category titles

## 3.3.0-rc2
* Merged forward from 3.1.17
  * Fixed duplicate notifications being sent to publishers when saving a new
    draft article with a cover image (Disco 017368)
* Fixed notifications including incomplete (relative) links to users profiles
* Added more complete REST API

## 3.3.0-rc
* Compatibility with Claromentis 8.2

## 3.2.6
* Fix document images not showing on PDF download (DISCO #018015)

## 3.2.5
* Merged forward from 3.1.17
  * Fixed duplicate notifications being sent to publishers when saving a new
    draft article with a cover image (Disco 017368)
* Fixed notifications including incomplete (relative) links to users profiles

## 3.2.4
* Fixed article sorting from newest to oldest
* Fixed pages component default sorting

## 3.2.3
* Fixed not showing subcategories in IE
* Fixed downloading articles as PDF when Gallery images are used

## 3.2.2
* Clearing cache of recent articles and questions when an article or question is saved
* Added endorsement sign to the articles list
* Added ability to edit creation date for articles (only dates in the past)
* Included subcategories while running advanced search (requires reindexing) (from 3.1.13)
* Fixed not loading additional articles and questions from subcategories when scrolling page down (#473) (from 3.1.13)
* Fixed categories alignment in the middle area (#478) (from 3.1.13)

## 3.2.1
* Improved the speed of generating categories tree dropdown
* Added German translations (disco 15862)

## 3.2.0
* Integrated all changes between 3.1.5 and 3.1.10

## 3.2.0-rc
* Compatibility with Claromentis 8.1
* Added Pages application components
* Implemented A-Z sorting for article and question listings
* Implemented the ability to disable questions altogether from the admin panel
* Implemented session storage for listing sort order preference
* Added more options to the Recent Articles/Questions components
* Added Metadata to Articles

## 3.1.18
* Fix document images not showing on PDF download (DISCO #018015)

## 3.1.17
* Fixed duplicate notifications being sent to publishers when saving a new
  draft article with a cover image (Disco 017368)

## 3.1.16
* Changed answer sorting order in questions from newest first to oldest first (DISCO #017130)

## 3.1.15
* Added German translations

## 3.1.14
* Fix gallery images not showing on PDF download (DISCO #016727)

## 3.1.13
* Included subcategories while running advanced search (requires reindexing)
* Fixed not loading additional articles and questions from subcategories when scrolling page down (#473)
* Fixed categories alighment in the middle area (#478)

## 3.1.12
* Improved the speed of generating categories tree dropdown

## 3.1.11
* Added German translations (disco 15862)

## 3.1.10
* Allow more than 2000 characters in category description

## 3.1.9
* Fixed a bug preventing "add article" page showing correctly on MSSQL (#466)
* Allow commenting articles to everyone with "view" permissions (#471)
* Increased max number of categories shown in admin area

## 3.1.8
* Fixed mismatching "contents" field type in ElasticSearch index
  NOTE: reindexing is required

## 3.1.7
* Fixed an issue with category list population, when creating an article, that
  prevented publishing to a parent category the user has full rights to (#467).
* Minor improvement category list performance when creating a new article
  (see 64b26f57)

## 3.1.6
* Fixed users being unable to create articles for sub-categories when they
  don't have create permissions for respective parent categories (#465).
* German localization fixes

## 3.1.5
* Fix MSSQL group by bug

## 3.1.4
* Fixed a minor bug when viewing an article with translations
* Fix slow search query for article lists (disco 14949)
* Removed unused details link field for whats new data. (#417)

## 3.1.3
* Fix for headers/footers in article PDF download
* Other small bugfixes

## 3.1.2
* Fixed searching by keywords in MSSQL
* Other small bugfixes

## 3.1.1
* Added German translation
* Several improvements to outputting articles to PDF

## 3.1.0
* Separated notifications for comments and replies
* Added function to download article as PDF
* Added support for displaying KB articles in "what's new"

## 3.0.0
* Compatibility with Claromentis 8.0 and Bootstrap 3
* Removed dependency on Innovate for comments and likes

## 2.10.3
* Minor bugfixes

## 2.10.2
* Minor bugfixes

## 2.10.1
* Fixed incorrect handling of UTF-8 strings breaking REST endpoints
* Improved performance of category loading

## 2.10.0
* Implemented multi-level subcategories. They can now be nested deeper than one
  level
* Added component plugin hooks for other modules to make use of

## 2.9.4 - 2.9.6
* Minor bugfixes

## 2.9.3
* Subscriptions filter for articles and questions list
* Subscription pin flag icon in article and question titles to indicate a
  subscription - internal, components and global search

## 2.9.2
* Public visibility fixes and improvements

## 2.9.1
* Public visiblity for articles and questions list

## 2.9.0
* Subscriptions - Subscribe to your favourite categories, articles and questions
  to receive notifications whenever something happens
* Global search results
  - Restricted article content length
  - Restored endorsement icon for endorsed articles

## 2.8.0
* Improved multilingual support
  - Articles are listed in whichever language is most relevant to the user
  - All article translations share the same cover image, embedded video and
    tags, but still have separate likes and comments as before
* Improved Elasticsearch integration which is now used for the internal search
* Improved notifications
  - Users with publish permissions for a category will receive a notification
    when draft articles are submitted or edited by users without these
    permissions
  - Article creators will receive notifications if anyone edits or changes the
    status of their article
  - Question authors and anyone who has posted a comment to a question will
    receive notifications when a new comment is posted
* It is now possible to view archived articles and questions
* **Be sure to reindex and recreate search mappings for articles and questions**

## 2.7.0
* New full text searching (requires Claromentis 7.4+)

## 2.6
* Load balancing support (requires Claromentis 7.3+)

## 2.1-2.3
* Bugfixes

## 2.0
Compatibility with Claromentis 7.2
* New features implemented for articles
* Added questions
* Added multilevel categories
* Added support for global search
* Added complex permissions

## 1.2.5
Compatibility with Claromentis 7.2
* Files structure brought to 7.2 standard
* Compatibility with new backbone.js
* TODO: remove status line

## 1.2.4
* Added 'article title' restriction to 100 characters
* Fixed default language preselection in home page list
* Added default language preselection in recent articles

## 1.2.3
* Enabled fulltext search
* Fix: Wrong publisher date displayed in article page
* Added 'Latest modified date' in article page
* Added search by url support
* Divided main search from tak cloud search
* Fixed Digest 'permission' error

## 1.2.2
* Fix: Clearing left margin when "span's" drop onto a new line.
* Fix: Removed trailing comma's error in home.js

## 1.2

* Made design improvements to the Article page style
* Tags for each Article are now displayed on the search results page
* Added an edit icon on the Article page.
* Fix: Resolved issue with CKFinder not being able to find documents
* Fix: Publisher avatar size


## 1.1
* Fix: IM Messages should now work

## 1.0
Initial Release
