define(['jquery', 'cla_select2'], function($) {
	return function() {
		if (!CKEDITOR.instances.message_body) {
			CKEDITOR.replace('message_body', {
				"customConfig": "/intranet/common/ckeditor/editor_config.php?application=knowledgebase",
				"height": 400
			});
		}

		$("#js-article-category").select2({
			placeholder: 'Select a Category',
			width: '100%',
			allowClear: true
		});

		// Check whether the user can publish to the selected category
		userCanPublishInSelectedCategory();

		$("#js-article-category").on("change", function(e) {
			userCanPublishInSelectedCategory();
		});

		// Prompt the user when trying to leave the page with unsaved changes
		var formDirty = false;
		var article = new Article("#js-form-article");

		CKEDITOR.instances.message_body.on('change', function() {
			formDirty = true;
		});

		$('#js-form-article').on('input change', 'input, textarea', function() {
			formDirty = true;
		});

		var beforeUnloadHandler = function(e) {
			if (article.hasFormChanged() || formDirty) {
				e.preventDefault();
				e.returnValue = '';
				return e.returnValue;
			}
		};

		window.addEventListener('beforeunload', beforeUnloadHandler);

		$('.js-submit-btn-add, .js-submit-btn-edit, .js-cancel-btn-add, .js-cancel-btn-edit').on('click', function(e) {
			window.removeEventListener('beforeunload', beforeUnloadHandler);

			formDirty = false;
		});
	};
});

function userCanPublishInSelectedCategory() {
	$.ajax({
		url: '/intranet/knowledgebase/check_user_can_publish_ajax.php',
		data: {
			category_id: $("#js-article-category").val(),
			csrf_token: $('#csrf_token').val()
		},
		type: 'post',
		success: function(json) {
			var j = $.parseJSON(json);

			if (j.error == 0 && j.can_publish === true) {
				$("#statusContainer").show();
				$("#statusContainerNoPerms").hide();
				$("#categoryNoPerms").hide();
				return true;
			}

			$("#statusContainer").hide();
			$("#statusContainerNoPerms").show();
			$("#categoryNoPerms").show();
		}
	});
}

// Article constructor
function Article(el) {
	this.$el = $(el);
	this.form_state = '';

	if (CKEDITOR.instances.message_body) {
		this.updateFormState();
	} else {
		CKEDITOR.on('instanceReady', function(e) {
			if (e.editor.name === 'message_body') {
				this.updateFormState();
			}
		}.bind(this));
	}
}

Article.prototype.composeFormState = function() {
	var ckeditorContent = CKEDITOR.instances.message_body ? CKEDITOR.instances.message_body.getData() : '';
	var serializedForm = this.$el.serializeArray();
	var imageHash = $('#article_image_special_id').val();
	var imageUrl = $('.js-current-image').css('background-image');
	var deleteImageChecked = $('input[name="article_image[delete]"]').is(':checked');

	return {
		formData: serializedForm,
		message_body: ckeditorContent,
		image_hash: imageHash,
		image_url: imageUrl,
		delete_image: deleteImageChecked
	};
};

// Update form state using the composed state
Article.prototype.updateFormState = function() {
	this.form_state = JSON.stringify(this.composeFormState());
};

// Get the current state for comparison
Article.prototype.getCurrentState = function() {
	return JSON.stringify(this.composeFormState());
};

// Compare current state with the original state
Article.prototype.hasFormChanged = function() {
	return this.getCurrentState() !== this.form_state;
};
