<?php
$_db_migration_to = '01.01';
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('00_schema.php', <<<'DB_UPDATE_FILE'
<?php

//INSTALL
$DROP_TABLES = TRUE;

/**
 * Articles group table
 */
$db->CreateTable('kb_article_group',array(
    'id'                        => 'IDENTITY',
    'var'                       => 'INT'
),$DROP_TABLES);

/**
 * Article table
 */
$db->CreateTable('kb_article',array(
    'id'                        => 'IDENTITY',
    'article_group_id'          => 'INT',
    'language'                  => 'VARCHAR(50)',
    'title'                     => 'VARCHAR(255)',
    'publisher_id'              => 'INT',
    'article_text'              => 'CLOB',
    'publish_from'              => 'INT_DATE',
    'publish_to'                => 'INT_DATE',
    'hide_article'              => 'INT',
    'created_by'                => 'INT',
    'created_date'              => 'INT_DATE',
    'modified_by'               => 'INT',
    'modified_date'             => 'INT_DATE',
),$DROP_TABLES);
//$db->query('ALTER TABLE kb_article MODIFY article_text text DEFAULT NULL');

$db->CreateIndex('kb_article', 'idx_article_group_id', 'article_group_id');
$db->CreateIndex('kb_article', 'idx_publisher_id', 'publisher_id');

/**
 * Articles visit statistics table
 */
$db->CreateTable('kb_article_visit_stats',array(
    'id'                        => 'IDENTITY',
    'article_id'                => 'INT',
    'language'                  => 'VARCHAR(50)',
    'user_id'                   => 'INT',
    'visit_timestamp'           => 'INT_DATE'
),$DROP_TABLES);

$db->CreateIndex('kb_article_visit_stats', 'idx_article_id', 'article_id');

/**
 * Categories table
 */
$db->CreateTable('kb_category',array(
    'id'                        => 'IDENTITY',
    'name'                      => 'VARCHAR(255)',
    'created_by'                => 'INT',
    'created_date'              => 'INT_DATE',
    'modified_by'               => 'INT',
    'modified_date'             => 'INT_DATE'
),$DROP_TABLES);

/**
 * Category article bridge table
 */
$db->CreateTable('kb_category_article',array(
    'id'                        => 'IDENTITY',
    'category_id'               => 'INT',
    'article_id'                => 'INT'
),$DROP_TABLES);

$db->CreateIndex('kb_category_article', 'idx_category_id', 'category_id');
$db->CreateIndex('kb_category_article', 'idx_article_id', 'article_id');


DB_UPDATE_FILE
);


$migrations->Run('01_admin_css_class.php', <<<'DB_UPDATE_FILE'
<?php

$db->query("UPDATE panels SET css_class=str:css WHERE symname=str:pn", 'glyphicons-tree-deciduous', 'knowledgebase');


DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('01.01');
