define(['jquery'], function($){
	return function(){


		$("#KBImageCropModalTrigger").click(function () {
			$('#KBImageCropModal').modal('show');
			return false;
		});

		$('#KBImageCropModal').on('show.bs.modal', function () {
			init();
		});

		//if user select a picture
		$('#KBImageFile').change(function () {
			$("#KBImageUploadForm").submit(); //submit form
			return false;
		});

		//once form is submitted post it over ajax
		$('#KBImageUploadForm').submit(function () {
			$(this).ajaxSubmit(options);
			return false;
		});

		//save & crop buttom pressed
		$("#CropSave").click(function () {
			cropSave();
			return false;
		});

		$("#crop_img_hash").bind("crop_img_updated", function () {

			//console.log('recieved hash:');
			//console.log($('#crop_img_hash').val());

			var img_src = "/intranet/knowledgebase/get_cover_image.php?type=tmp&id=" + $('#crop_img_hash').val() + "&t=" + new Date().getTime();
			$('#js-article-cover-preview').empty();
			var $img = $('<img src="" alt="" />').attr('src', img_src).attr("alt", img_name).addClass('img-polaroid').attr('style', 'max-width: 721; max-height: 300px;');
			var $wrap = $('<p></p>').append($img);
			var $reset = $("<a></a>").addClass('btn btn-danger article-cover-remove').html(lmsg('knowledgebase.article.cover_image_remove_btn'));
			$('#js-article-cover-preview').append($wrap).append($reset);
		});

		$(document).on("click", ".article-cover-remove", function () {

			var articleId = $('#articleCoverID').val();
			$.ajax({
				url: '/intranet/knowledgebase/remove_article_cover_ajax.php',
				data: {
					article_id: articleId,
					img_hash: img_hash,
					csrf_token: $('#csrf_token').val()
				},
				type: 'POST'
			})
				.done(function (json) {
					var response = $.parseJSON(json);

					if (response.error == true) {
						alert(response.msg);
					} else {
						$('#js-article-cover-preview').fadeOut('slow', function () {
							$(this).empty();
							$(this).show();
						});
						removeImageData();
					}
				});

			return false;
		});
	};
});

var progressbar = $("#KBProgressBar");

var img_hash = '';
var img_name = '';
var img_size = 0;

var pos_x = 0;
var pos_y = 0;
var pos_w = 0;
var pos_h = 0;

var options = {
	beforeSubmit: beforeSubmit, //bind
	uploadProgress: onProgress, //bind
	success: afterSuccess, //bind
	resetForm: true
};

function toggleView(selector) {
	$("[id^=KBUploadView]").hide(); //hide all
	$(selector).show();
	clearErrors(); //clear all errors
}

function clearErrors() {
	$(".upload-error").hide().html(""); //clear messages
}

function showErrors(err_msg) {
	$(".upload-error").html(err_msg).show();
}

function init() {
	$("#KBImageFile").val(''); //clear file element
	$("#CropSave").hide(); //hide save button
	toggleView("#KBUploadView1");
}

function updateCoords(c) {
	pos_x = c.x;
	pos_y = c.y;
	pos_w = c.w;
	pos_h = c.h;
}

//do some VI changes before uploading
function beforeSubmit() {
	progressbar.width("0%"); //set progress bar to 0%
	toggleView("#KBUploadView2");
}

//update progress during upload process
function onProgress(event, position, total, percentComplete) {
	progressbar.width(percentComplete + '%'); //update progressbar percent complete
}

//after succesful upload
function afterSuccess(responseText, statusText, xhr, $form) {

	var response = JSON.parse(responseText); //get response from server

	//if error
	if (response.error == true) {
		init();
		showErrors(response.error_msg);
		return false;
	}

	//set image details
	img_hash = response.hash; //temporary image name
	img_name = response.name; //native image name
	img_size = response.size; //image size

	//var img = new Image();
	//img.onload = function(){
	//alert(img.width);
	//alert(img.height);
	//};
	//img.src = img_url;

	//get uploaded file and pass it to img element
	var img_url = '/intranet/knowledgebase/get_cover_image.php?type=tmp&id=' + response.hash;
	//construct new image element
	var image = $('<img/>');
	//wait until image loaded!
	image.load(function () {
		//apply Jcrop : http://deepliquid.com/content/Jcrop.html
		image.Jcrop({
			boxWidth: 568,   //image preview max width
			boxHeight: 400,   //image preview max height
			bgFade: true,
			bgColor: 'black',
			bgOpacity: .4,
			minSize: [480, 200],    //crpo box min width x height using aspect ratio below
			setSelect: [20, 20, 200, 200], //preselect position
			aspectRatio: 24 / 10,
			onSelect: updateCoords
		});
		//show KBUploadView3
		toggleView("#KBUploadView3");
		//show Crop & Save button
		$("#CropSave").show();
	});
	//add image attributes and hide it (we dont need to show it!)
	image.attr('src', img_url).attr('id', 'KBImageCrop').hide();
	//append to modal body
	$("#jcropWrapper").empty().append(image);
}

function outputTmpImageData(hash, name, size) {
	$('#crop_img_name').val(name);
	$('#crop_img_size').val(size);
	$('#crop_img_hash').val(hash)
		.trigger('crop_img_updated'); //trigger image updated event
}

function removeImageData() {
	$('#articleCoverID').val('');
	$('#crop_img_name').val('');
	$('#crop_img_size').val('');
	$('#crop_img_hash').val('');
}

//crop image and save
function cropSave() {

	$("#CropSave").prop('disabled', true);

	$.ajax({
		type: "POST",
		url: "/intranet/knowledgebase/image_crop_ajax.php",
		data: {img_hash: img_hash, x: pos_x, y: pos_y, w: pos_w, h: pos_h, csrf_token: $('#csrf_token').val()}
	})
		.done(function (json) {

			$("#CropSave").prop('disabled', false);

			var response = JSON.parse(json);

			//if error after crop action
			if (response.error == true) {
				showErrors(response.error_msg);
				return false;
			}

			$("#jcropWrapper").empty();
			$('#KBImageCropModal').modal('hide');
			outputTmpImageData(img_hash, img_name, img_size);
		});
}