define(['jquery', 'cla_select2'], function($){
	return function(){
		// namespacing
		var select2 = {};

		select2.format = function(lang){
			var flag = $(lang.element).val();

			// bug - initial selected option doesn't work so setting default flag image to 'en'
			if(lang.element === undefined) {
				var selected_flag = $("#language").val();
				if(selected_flag === undefined) {
					flag = "en";
				} else {
					flag = selected_flag;
				}
			}
			return '<img src="/images/default/languages/small/' + flag + '.gif" /> ' + lang.text;
		};

		$("#article-category, #question-category, #category_list").select2( { width: '100%', minimumResultsForSearch : 20, placeholder : lmsg('knowledgebase.index_search.categories') } );

		$("#status_article").select2( { width: '100%', minimumResultsForSearch : 20} );

		$("#language_select").select2({
			width: 'element',
			width: '100%',
			minimumResultsForSearch : 20,
			placeholder : lmsg('knowledgebase.index_search.languages'),
			templateResult: select2.format,
			templateSelection: select2.format,
			escapeMarkup: function(markup) { return markup; }
		}).on("change", function(e) {
			var target = $(e.target);
			var articleId = parseInt(target.find("option:selected").attr("data-article-id"), 10);
			var slug = target.find("option:selected").attr("data-slug");
			var lang = target.find('option:selected').val();

			if (target.hasClass("admin_lang")) {
				if (articleId > 0) {
					window.location = "admin_article.php?id=" + articleId + '&lang=' + lang;
				}
			} else if (target.hasClass("js-front-lang")) {
				if (articleId > 0) {
					window.location = "/knowledgebase/articles/" + articleId + '/' + lang + '/' + slug;
				}
			}
		});

		$("#search_clear_btn").click(function(){
			$("#keyword").val('');
			$("#article-category").select2("val", 0);
			$("#language").select2("val", '');
			$("#status_article").select2("val", -1);

			$("#question-category").select2("val", 0);
			$("#archived").prop('checked', false);
			return false;
		});

		$("#reset_advanced_search_btn").on('click', function(e){
			e.preventDefault();
			$("#advanced_search_title").val('');
			$("#advanced_search_keyword").val('');
			$('#advanced_search_category').find('option:first').attr('selected', 'selected');
			$('#advanced_search_category_type').find('option:first').attr('selected', 'selected');

			return false;
		});

		$("#simple_search").click(function(e){

			if($("#simple_search_keyword").val() == "") {
				e.preventDefault();
				return false;
			}

			return true;
		});
	};
});
