<?php
if (!defined('INSTALL_PROGRESS'))
	die("This file cannot be executed directly");

if (!isset($installer))
	throw new Exception("Install options are not defined");
/** @var $installer Claromentis\Setup\SetupFacade */

//Create Default Category UNCATEGORISED
$db = $installer->GetDb();
$now = Date::getNowTimestamp();
$db->query(new Claromentis\Core\DAL\QueryInsert('kb_category', array(
    'str:name' => "Uncategorised",
    'int:created_by' => 1,
    'int:created_date' => $now
)));

$DATA_DIR = $installer->GetDataDir();

$dataDirectories = [
	"$DATA_DIR/knowledgebase",
	"$DATA_DIR/knowledgebase/article_covers",
	"$DATA_DIR/knowledgebase/tmp"
];

foreach ($dataDirectories as $dataDirectory) {
	if (!is_dir($dataDirectory)) {
		mkdir($dataDirectory, 0775, true);
		chmod($dataDirectory, 0775);
	}
}

$cdn = Claromentis\Core\Services::I()->GetCDN();
if (!$cdn->IsDir('knowledgebase'))
	$cdn->CreateDir('knowledgebase');
$cdn->CreateDir('knowledgebase/images');

$plugins = $installer->GetPluginsRepository();
$plugins->Add('knowledgebase', "KnowledgebasePlugin");

// make admin panel visible
$panels = $installer->GetAdminPanelCreator();
$panels->Enable('knowledgebase');

use Claromentis\Core\Services;
use Claromentis\Menu\Infobar\MenuItemApplication;
use Claromentis\Menu\Infobar\MenuItemRepository;

$menu = Services::I()->{MenuItemRepository::class};
$menu->save(new MenuItemApplication('knowledgebase', 'Knowledge Base', '/knowledgebase/'));
