<?php
$_db_migration_to = '07.01';
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('01_namespaces.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations Claromentis\Setup\SetupFacade */

$innovate_config = $migrations->GetConfigFull('innovate');
$aggr = $innovate_config->Get('cfg_aggregation_classes');
$aggr["article"] = '\Claromentis\Knowledgebase\KBArticleTranslation';
$aggr["question"] = '\Claromentis\Knowledgebase\KBQuestion';
$innovate_config->Set('cfg_aggregation_classes', $aggr);
$innovate_config->Save();

DB_UPDATE_FILE
);


$migrations->Run('02_move_innovate_comments.php', <<<'DB_UPDATE_FILE'
<?php
use Claromentis\Core\DAL;
/** @var $migrations Claromentis\Setup\SetupFacade */

class Migration_KB_02MoveInnovateComments_ER9iuHaf
{
	private $delete_old;
	private $db;
	private $data_dir;

	public function __construct(DAL\Db $db, $data_dir, $delete_old = true)
	{
		$this->db = $db;
		$this->delete_old = $delete_old;
		$this->data_dir = $data_dir;
	}

	public function MigrateAggregation($aggregation)
	{
		$res = $this->db->query("SELECT * FROM innovate_comments WHERE aggregation=int:aggr", $aggregation);
		while ($arr = $res->fetchArray())
		{
			$this->MigrateComment($arr);
		}

		if ($this->delete_old)
			$this->db->query("DELETE FROM innovate_comments WHERE aggregation=int:aggr", $aggregation);
	}

	private function MigrateComment($innovate_comment_info)
	{
		$query = new DAL\QueryInsert('discussions', array(
				'int:user_id' => $innovate_comment_info['user_id'],
				'int:object_id' => $innovate_comment_info['object_id'],
				'int:ancillary' => null,
				'int:aggregation' => $innovate_comment_info['aggregation'],
				'int:parent_id' => 0,
				'str:txt' => $innovate_comment_info['txt'],
				'int:timestamp' => $innovate_comment_info['timestamp'],
				'int:like_count' => $innovate_comment_info['like_count'],
				'int:reply_count' => $innovate_comment_info['reply_count'],
			)
		);
		$this->db->query($query);
		$new_comment_id = $this->db->insertId();

		if ($innovate_comment_info['attachment_id'])
			$this->MigrateAttachments($innovate_comment_info['attachment_id'], $new_comment_id);

		$this->MigrateReplies($innovate_comment_info, $new_comment_id);
	}

	private function MigrateAttachments($attachment_id, $new_comment_id)
	{
		$new_data_dir = $this->data_dir.'/discussion';
		if (!is_dir($new_data_dir))
			mkdir($new_data_dir, 0777);


		$att_res = $this->db->query("SELECT * FROM innovate_attachments WHERE id=int:id", $attachment_id);
		if ($att_res->hasData())
		{
			$att_arr = $att_res->fetchArray();
			if (preg_match('/\.([\w\d_]+)$/', $att_arr['name'], $matches))
			{
				$extension = $matches[1];
			} else
			{
				$extension = '';
			}
			$query = new DAL\QueryInsert('discussion_attachments', array(
                     'int:discussion_id' => $new_comment_id,
                     'int:doc_id' => $att_arr['doc_id'],
                     'str:name' => $att_arr['name'],
                     'str:extension' => $extension,
                     'str:path' => $att_arr['path'],
                     'int:type' => $att_arr['type'],
                 )
			);

			$this->db->query($query);
			$new_attachment_id = $this->db->insertId();

			$this->MigrateAttachmentFile($attachment_id, $new_attachment_id);
			$this->MigrateAttachmentFile($attachment_id.'_large', $new_attachment_id.'_lg');
			$this->MigrateAttachmentFile($attachment_id.'_thumb', $new_attachment_id.'_sm');

			if ($this->delete_old)
				$this->db->query("DELETE FROM innovate_attachments WHERE id=int:id", $attachment_id);
		}
	}

	private function MigrateAttachmentFile($old_name, $new_name)
	{
		$new_data_dir = $this->data_dir.'/discussion';
		$innovate_data_dir = $this->data_dir.'/innovate/attachments';

		if (is_file($innovate_data_dir.'/'.$old_name.'.dat'))
			if ($this->delete_old)
				rename($innovate_data_dir.'/'.$old_name.'.dat', $new_data_dir.'/'.$new_name.'.dat');
			else
				copy($innovate_data_dir.'/'.$old_name.'.dat', $new_data_dir.'/'.$new_name.'.dat');
	}

	private function MigrateReplies($old_comment_info, $new_comment_id)
	{
		$old_comment_id = $old_comment_info['id'];
		$res = $this->db->query("SELECT * FROM innovate_replies WHERE comment_id=int:id", $old_comment_id);
		if ($res->hasData())
		{
			while ($arr = $res->fetchArray())
			{
				$query = new DAL\QueryInsert('discussions', array(
						'int:user_id' => $arr['user_id'],
						'int:object_id' => $old_comment_info['object_id'],
						'int:ancillary' => null,
						'int:aggregation' => $old_comment_info['aggregation'],
						'int:parent_id' => $new_comment_id,
						'str:txt' => $arr['txt'],
						'int:timestamp' => $arr['timestamp'],
						'int:like_count' => 0,
						'int:reply_count' => 0,
					)
				);
				$this->db->query($query);
			}
		}

		if ($this->delete_old)
			$this->db->query("DELETE FROM innovate_replies WHERE comment_id=int:id", $old_comment_id);
	}

}

$db = $migrations->GetDb();
$delete_old = true;
$comments_migrator = new Migration_KB_02MoveInnovateComments_ER9iuHaf($migrations->GetDb(), $migrations->GetDataDir(), $delete_old);
$comments_migrator->MigrateAggregation(110); // 110 is AGGREGATION_KNOWLEDGEBASE_ARTICLE
$comments_migrator->MigrateAggregation(112); // 112 is AGGREGATION_KNOWLEDGEBASE_QUESTION

DB_UPDATE_FILE
);


$migrations->Run('03_remove_aggregations_from_innovate.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations Claromentis\Setup\SetupFacade */

$innovate_config = $migrations->GetConfigFull('innovate');
$aggr = $innovate_config->Get('cfg_aggregation_classes');
unset($aggr["article"]);
unset($aggr["question"]);
if (empty($aggr))
	$innovate_config->Delete('cfg_aggregation_classes');
else
	$innovate_config->Set('cfg_aggregation_classes', $aggr);

$innovate_config->Save();

DB_UPDATE_FILE
);


$migrations->Run('04_move_likes.php', <<<'DB_UPDATE_FILE'
<?php
use Claromentis\Core\DAL;
/** @var $migrations Claromentis\Setup\SetupFacade */

$db = $migrations->GetDb();

$aggregations = [110 /*AGGREGATION_KNOWLEDGEBASE_ARTICLE*/, 112 /*AGGREGATION_KNOWLEDGEBASE_QUESTION*/];
$db->query("INSERT INTO likes (user_id, object_id, aggregation, timestamp)
	SELECT user_id, object_id, aggregation, timestamp FROM innovate_likes WHERE aggregation IN in:int:aggr",
    $aggregations);

$db->query("DELETE FROM innovate_likes WHERE aggregation IN in:int:aggr",
    $aggregations);


DB_UPDATE_FILE
);


$migrations->Run('05_aggregation_translation.php', <<<'DB_UPDATE_FILE'
<?php
use Claromentis\Core\DAL;
/** @var $migrations Claromentis\Setup\SetupFacade */

$db = $migrations->GetDb();

$db->query("UPDATE likes SET aggregation=int:trans WHERE aggregation=int:art", 131 /*AGGREGATION_KNOWLEDGEBASE_TRANSLATION*/, 110 /*AGGREGATION_KNOWLEDGEBASE_ARTICLE*/);

$db->query("UPDATE discussions SET aggregation=int:trans WHERE aggregation=int:art", 131 /*AGGREGATION_KNOWLEDGEBASE_TRANSLATION*/, 110 /*AGGREGATION_KNOWLEDGEBASE_ARTICLE*/);

DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('07.01');
