define(['../../../node_modules/intersection-observer-polyfill/dist/IntersectionObserver.global'], function(IntersectionObserver) {
	var ScrollObserver = function() {};

	ScrollObserver.prototype.observer = null;
	ScrollObserver.prototype.observerTarget = null;

	ScrollObserver.prototype.registerScrollListener = function() {
		this.observerTarget = document.querySelector('#load_more_content');
		this.observer = new IntersectionObserver(function(intersections) {
			intersections.forEach(function (item) {
				if (item.intersectionRect.height > 0)
				{
					var element = document.querySelector('.js-scroll-container');
					if (element !== null) {
						// In Claro 9, use the generic version (and for the listener)
						// IE11 Doesn't support it so using jQuery for now
						//element.dispatchEvent(new Event("onScrollListEnd", {}));

						$('.js-scroll-container').trigger("onScrollListEnd");
					}
				}
			});
		});

		this.observer.observe(this.observerTarget);
	}

	ScrollObserver.prototype.unregisterScrollListener = function() {
		if (this.observerTarget !== null && this.observer !== null)
			this.observer.unobserve(this.observerTarget);

		this.observer = null;
		this.observerTarget = null
	}

	return ScrollObserver;
});
