/**
 * Learning record type filter control.
 *
 * @author Chris Andrew <chris.andrew@claromentis.com>
 */
(function () {
    'use strict';

    angular.module('cla.reports.report')
        .directive('repRecordTypeControl', repRecordTypeControl);

    repRecordTypeControl.$inject = ['$timeout'];

    function repRecordTypeControl($timeout) {
        var directive = {
            bindToController: true,
            controller: controller,
            controllerAs: 'filter',
            restrict: 'E',
            scope: {
                args: '='
            },
            templateUrl: '/intranet/learning/html/tmpl/reports/filters/record_type.html'
        };

        return directive;
        //////////////////

        function controller($scope, $element) {
            var ctl = this;

            ctl.change = change;

            ctl.lmsg = {
                placeholder: lmsg('learning.reports.filter.record_type.placeholder')
            };

            ctl.options = [];

            init();

            function init() {
                fill();

                $timeout(function () {
                    $element.find('.js-filter-record-type').val(ctl.args.values[0]).trigger('change');
                }, 0, true);
            }

            function fill() {
                for (var i in reports_data.filter_preload.record_type) {
                    var type = reports_data.filter_preload.record_type[i];

                    ctl.options.push(
                        { text: type, value: i }
                    )
                }
            }

            /** change event */
            function change(value) {
                ctl.args.operator = "equals";
                ctl.args.values[0] = value;
            }
        }
    }
}());
