<?php
$_db_migration_to = '01.01';
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('01_initial_schema.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

$table_descr = array(
	'id'            => "IDENTITY",
	'title'         => "VARCHAR(255) NULL",
	'description'   => "VARCHAR_MAX NULL",
	'qualification' => "VARCHAR(255) NULL",
	'needed_score'  => "INT NULL",
	'status'        => "INT NOT_NULL",
	'created_by'	=> "INT NOT_NULL",
	'created_date'	=> "INT_DATE NULL",
    'image_ext'     => "INT NOT_NULL DEFAULT -1"
);
$db->CreateTable('learning_path', $table_descr, true);
// learning path image stored in CDN with name equal to learning path ID
// permissions are bound to learning path ID

$table_descr = array(
	'id'            => "IDENTITY",
	'title'         => "VARCHAR(255) NULL",
	'description'   => "VARCHAR_MAX NULL",
	'req_level'     => "INT NOT_NULL",  // mandatory, non-mandatory main, non-mandatory recommended
	'course_type'   => "INT NOT_NULL", // course, event, qualification (certificate)
	'qualification' => "VARCHAR(255) NULL",
	'score'         => "INT NOT_NULL DEFAULT 10",
    'item_order'    => "INT NOT_NULL",
	'created_by'	=> "INT NOT_NULL",
	'created_date'	=> "INT_DATE NULL",
	'path_id'		=> "INT NOT_NULL"
);
$db->CreateTable('learning_path_item', $table_descr, true);
// item image stored in CDN with name equal to item ID


$table_descr = array(
	'id'			  => 'IDENTITY',
	'user_id'		  => 'INT NOT_NULL',
	'path_id'		  => 'INT NOT_NULL',
	'running_total'	  => 'INT NOT_NULL',
	'date_enrolled'	  => 'INT_DATE NULL',
	'date_completed'  => 'INT_DATE NULL',
	'date_updated'	  => 'INT_DATE NULL',
	'date_deadline'	  => 'INT_DATE NULL',
	'deadline_reason' => 'VARCHAR_MAX NULL',
	'pulled_out'	  => 'INT NULL'
);
$db->CreateTable('learning_path_enrollment', $table_descr, true);
$db->CreateIndex('learning_path_enrollment', 'idx_user_path_id', 'user_id', 'path_id');


$table_descr = array(
	'id'              => "IDENTITY",
	'user_id'         => "INT NOT_NULL",
	'added_by'        => "INT NOT_NULL",
	'record_type'     => "INT NOT_NULL", // training, event
	'title'           => "VARCHAR(255) NULL",
	'description'     => "VARCHAR_MAX NULL",
	'record_date'     => "INT_DATE NULL",     // completion date
	'provider'        => "VARCHAR(255) NULL",
	'code'            => "VARCHAR(255) NULL", // course code
	'status'          => "INT NOT_NULL",
    'has_certificate' => "INT NOT_NULL" // if yes, check learning_certificate table
);
$db->CreateTable('learning_record', $table_descr, true);


$table_descr = array(
	'id'            => "IDENTITY",
	'user_id'       => "INT NOT_NULL",
	'added_by'      => "INT NOT_NULL",
	'title'         => "VARCHAR(255) NULL",
	'qualification' => "VARCHAR(255) NULL",
	'valid_from'    => "INT_DATE NULL",
	'valid_to'      => "INT_DATE NULL",
	'code'          => "VARCHAR(255) NULL", // certificate license ID
	'url'           => "VARCHAR(1024) NULL", // online certificate URL
	'record_id'     => "INT NULL",  // reference to "learning_record" table
    'file_ext'      => "INT NOT_NULL DEFAULT -1"
);

$db->CreateTable('learning_certificate', $table_descr, true);


$table_descr = array(
	'id'			=> 'IDENTITY',
	'code'			=> 'VARCHAR(255) NULL'
);
$db->CreateTable('learning_qualification_code', $table_descr, true);


$table_descr = array(
	'id'			=> 'IDENTITY',
	'aggregation'	=> 'INT NOT_NULL',
	'object_id'		=> 'INT NOT_NULL',
	'code'			=> 'VARCHAR(255) NULL',
	'code_id'		=> 'INT NOT_NULL',
	'title'			=> 'VARCHAR(255) NULL'
);
$db->CreateTable('learning_object_code', $table_descr, true);
$db->CreateIndex('learning_object_code', 'idx_aggr_object_id', 'aggregation', 'object_id');
$db->CreateIndex('learning_object_code', 'idx_aggr_code_id', 'code_id');


$table_descr = array(
	'id'			 => 'IDENTITY',
	'user_id'		 => 'INT NOT_NULL',
	'step_id'		 => 'INT NOT_NULL',
	'object_id'		 => 'INT NOT_NULL',
	'aggregation'	 => 'INT NOT_NULL',
	'date_completed' => 'INT_DATE NULL'
);
$db->CreateTable('learning_step_audit', $table_descr, true);
$db->CreateIndex('learning_step_audit', 'idx_user_step_id', 'user_id', 'step_id');
DB_UPDATE_FILE
);


$migrations->Run('02_certificates_drop_columns.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

$db->DropColumn('learning_certificate', 'description');
$db->DropColumn('learning_certificate', 'provider');
DB_UPDATE_FILE
);


$migrations->Run('03_certificates_modify_columns.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

$db->DropColumn('learning_certificate', 'file_type');
DB_UPDATE_FILE
);


$migrations->Run('04_path_create_directory.php', <<<'DB_UPDATE_FILE'
<?php


/**
 * chmod recursively, closure to avoid function conflict
 *
 * @param string $path
 * @param int $mod
 * @return bool
 */
$chmod_r = function ($path, $mod) use (&$chmod_r)
{
	if (!@chmod($path, $mod) || !is_dir($path) || !$dir = @opendir($path))
		return false;

	while (($file = @readdir($dir)) !== false)
	{
		if ($file == '.' || $file == '..')
		{
		} elseif (is_dir($path.'/'.$file))
		{
			if (!$chmod_r($path.'/'.$file, $mod))
				return false;
		} else
		{
			if (!@chmod($path.'/'.$file, $mod))
				return false;
		}
	}
	@closedir($dir);
	return @chmod($path, $mod);
};


// create learning app data directory
global $APPDATA;
$directory = $APPDATA . '/learning/';

if (file_exists($directory) && !file_exists($directory . 'paths'))
{
	mkdir($directory . 'paths');

	$chmod_r($directory . 'certificates', 0777);
	$chmod_r($directory . 'paths', 0777);
}
DB_UPDATE_FILE
);


$migrations->Run('05_path_audit_columns.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

$db->AddColumn('learning_path', 'created_by', 'INT NOT_NULL');
$db->AddColumn('learning_path', 'created_date', 'INT_DATE NOT_NULL');

$db->AddColumn('learning_path_item', 'created_by', 'INT NOT_NULL');
$db->AddColumn('learning_path_item', 'created_date', 'INT_DATE NOT_NULL');
DB_UPDATE_FILE
);


$migrations->Run('06_step_remove_columns.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

$db->DropColumn('learning_path_item', 'course_id');
DB_UPDATE_FILE
);


$migrations->Run('07_step_path_id_column.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

$db->AddColumn('learning_path_item', 'path_id', 'INT NOT_NULL');
DB_UPDATE_FILE
);


$migrations->Run('08_path_audit_setup.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

// create new tables (qualification codes and audits)

$table_descr = array(
	'id'			=> 'IDENTITY',
	'code'			=> 'VARCHAR(255) NULL'
);
$db->CreateTable('learning_qualification_code', $table_descr, true);

$table_descr = array(
	'id'			=> 'IDENTITY',
	'aggregation'	=> 'INT NOT_NULL',
	'object_id'		=> 'INT NOT_NULL',
	'code'			=> 'VARCHAR(255) NULL',
	'code_id'		=> 'INT NOT_NULL',
	'title'			=> 'VARCHAR(255) NULL'
);
$db->CreateTable('learning_object_code', $table_descr, true);
$db->CreateIndex('learning_object_code', 'idx_aggr_object_id', 'aggregation', 'object_id');
$db->CreateIndex('learning_object_code', 'idx_aggr_code_id', 'code_id');

$table_descr = array(
	'id'			 => 'IDENTITY',
	'user_id'		 => 'INT NOT_NULL',
	'step_id'		 => 'INT NOT_NULL',
	'date_completed' => 'INT_DATE NULL'
);
$db->CreateTable('learning_step_audit', $table_descr, true);
$db->CreateIndex('learning_step_audit', 'idx_user_step_id', 'user_id', 'step_id');


// existing enrollment table, drop, recreate
$table_descr = array(
	'id'			=> 'IDENTITY',
	'user_id'		=> 'INT NOT_NULL',
	'path_id'		=> 'INT NOT_NULL',
	'running_total'	=> 'INT NOT_NULL',
	'date_enrolled'	=> 'INT_DATE NULL',
	'date_completed'=> 'INT_DATE NULL',
	'date_updated'	=> 'INT_DATE NULL'
);
$db->CreateTable('learning_path_enrollment', $table_descr, true);
$db->CreateIndex('learning_path_enrollment', 'idx_user_path_id', 'user_id', 'path_id');
DB_UPDATE_FILE
);


$migrations->Run('09_insert_admin_panel.php', <<<'DB_UPDATE_FILE'
<?php

// Admin panel
$admin_panel = new \Claromentis\Setup\AdminPanel();
$admin_panel->Create('learning', '../learning/admin_learning-path.php', array('name' => 'Learning', 'css_class' => 'glyphicons glyphicons-education'));
DB_UPDATE_FILE
);


$migrations->Run('10_step_audit_columns.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

$db->AddColumn('learning_step_audit', 'object_id', 'INT NOT_NULL');
$db->AddColumn('learning_step_audit', 'aggregation', 'INT NOT_NULL');
DB_UPDATE_FILE
);


$migrations->Run('11_cleanup_db_columns.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

$db->DropColumn('learning_record', 'code');
$db->DropColumn('learning_path_item', 'course_type');
DB_UPDATE_FILE
);


$migrations->Run('12_path_audit_pullout_column.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

$db->AddColumn('learning_path_enrollment', 'date_deadline', 'INT_DATE NULL');
$db->AddColumn('learning_path_enrollment', 'deadline_reason', 'VARCHAR_MAX NULL');
$db->AddColumn('learning_path_enrollment', 'pulled_out', 'INT NULL');
DB_UPDATE_FILE
);


$migrations->Run('13_qualification_description.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

$db->AddColumn('learning_qualification_code', 'description', 'VARCHAR(255) NULL');
DB_UPDATE_FILE
);


$migrations->Run('14_image_extensions.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

$db->AddColumn('learning_certificate', 'file_ext', 'INT NOT_NULL DEFAULT 0');
$db->AddColumn('learning_path', 'image_ext', 'INT NOT_NULL DEFAULT 0');
DB_UPDATE_FILE
);


$migrations->Run('15_date_conversion.php', <<<'DB_UPDATE_FILE'
<?php
use \Claromentis\Core\DAL\QueryBuilder;

/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

$db->DisableTokenCheck();

/****
 * UPDATE LEARNING CERTIFICATES
 */

// updates to all date fields across the learning module
$qb = new QueryBuilder("SELECT id, valid_from, valid_to FROM learning_certificate");

$results = $db->query($qb->GetQuery());
$data = array();
$do_update = false;
while ($row = $results->fetchArray())
{
    $r1  =  $row['valid_from'];
    $r2  =  $row['valid_to'];

    if (strlen($r1) >= 10)
    {
        $d1 = new \Date($r1);
        $d1 = $d1->getDate(DATE_FORMAT_DATE_DAY);
        $do_update = true;
    }

    if (strlen($r2) >= 10)
    {
        $d2 = new \Date($r2);
        $d2 = $d2->getDate(DATE_FORMAT_DATE_DAY);
        $do_update = true;
    }

    if ($do_update)
    {
        $qu = new QueryUpdate("learning_certificate", "id=int:id");
        $qu->AddColumn("int:valid_from", $d1);
        $qu->AddColumn("int:valid_to", $d2);
        $qu->Bind("id", $row['id']);

        $db->query($qu);
    }
}

/****
 * UPDATE LEARNING PATH
 */

// updates to all date fields across the learning module
$qb = new QueryBuilder("SELECT id, created_date FROM learning_path");

$results = $db->query($qb->GetQuery());
$data = array();
$do_update = false;
while ($row = $results->fetchArray())
{
    $r1  =  $row['created_date'];

    if (strlen($r1) >= 10)
    {
        $d1 = new \Date($r1);
        $d1 = $d1->getDate(DATE_FORMAT_DATE_DAY);
        $do_update = true;
    }

    if ($do_update)
    {
        $qu = new QueryUpdate("learning_path", "id=int:id");
        $qu->AddColumn("int:created_date", $d1);
        $qu->Bind("id", $row['id']);

        $db->query($qu);
    }
}

/****
 * UPDATE LEARNING PATH ENROLLMENT
 */

// updates to all date fields across the learning module
$qb = new QueryBuilder("SELECT id, date_enrolled, date_completed, date_updated, date_deadline FROM learning_path_enrollment");

$results = $db->query($qb->GetQuery());
$data = array();
$do_update = false;
while ($row = $results->fetchArray())
{
    $r1  =  $row['date_enrolled'];
    $r2  =  $row['date_completed'];
    $r3  =  $row['date_updated'];
    $r4  =  $row['date_deadline'];

    if (strlen($r1) >= 10)
    {
        $d1 = new \Date($r1);
        $d1 = $d1->getDate(DATE_FORMAT_DATE_DAY);
        $do_update = true;
    }

    if (strlen($r2) >= 10)
    {
        $d2 = new \Date($r2);
        $d2 = $d2->getDate(DATE_FORMAT_DATE_DAY);
        $do_update = true;
    }

    if (strlen($r3) >= 10)
    {
        $d3 = new \Date($r3);
        $d3 = $d3->getDate(DATE_FORMAT_DATE_DAY);
        $do_update = true;
    }
    if (strlen($r4) >= 10)
    {
        $d4 = new \Date($r4);
        $d4 = $d4->getDate(DATE_FORMAT_DATE_DAY);
        $do_update = true;
    }

    if ($do_update)
    {
        $qu = new QueryUpdate("learning_path_enrollment", "id=int:id");
        $qu->AddColumn("int:date_enrolled", $d1);
        $qu->AddColumn("int:date_completed", $d2);
        $qu->AddColumn("int:date_updated", $d3);
        $qu->AddColumn("int:date_deadline", $d4);
        $qu->Bind("id", $row['id']);

        $db->query($qu);
    }
}

/****
 * UPDATE LEARNING PATH ITEM (STEPS)
 */

// updates to all date fields across the learning module
$qb = new QueryBuilder("SELECT id, created_date FROM learning_path_item");

$results = $db->query($qb->GetQuery());
$data = array();
$do_update = false;
while ($row = $results->fetchArray())
{
    $r1  =  $row['created_date'];

    if (strlen($r1) >= 10)
    {
        $d1 = new \Date($r1);
        $d1 = $d1->getDate(DATE_FORMAT_DATE_DAY);
        $do_update = true;
    }

    if ($do_update)
    {
        $qu = new QueryUpdate("learning_path_item", "id=int:id");
        $qu->AddColumn("int:created_date", $d1);
        $qu->Bind("id", $row['id']);

        $db->query($qu);
    }
}

/****
 * UPDATE LEARNING RECORD
 */

// updates to all date fields across the learning module
$qb = new QueryBuilder("SELECT id, record_date FROM learning_record");

$results = $db->query($qb->GetQuery());
$data = array();
$do_update = false;
while ($row = $results->fetchArray())
{
    $r1  =  $row['record_date'];

    if (strlen($r1) >= 10)
    {
        $d1 = new \Date($r1);
        $d1 = $d1->getDate(DATE_FORMAT_DATE_DAY);
        $do_update = true;
    }

    if ($do_update)
    {
        $qu = new QueryUpdate("learning_record", "id=int:id");
        $qu->AddColumn("int:record_date", $d1);
        $qu->Bind("id", $row['id']);

        $db->query($qu);
    }
}

/****
 * UPDATE LEARNING STEP AUDIT
 */

// updates to all date fields across the learning module
$qb = new QueryBuilder("SELECT id, date_completed FROM learning_step_audit");

$results = $db->query($qb->GetQuery());
$data = array();
$do_update = false;
while ($row = $results->fetchArray())
{
    $r1  =  $row['date_completed'];

    if (strlen($r1) >= 10)
    {
        $d1 = new \Date($r1);
        $d1 = $d1->getDate(DATE_FORMAT_DATE_DAY);
        $do_update = true;
    }

    if ($do_update)
    {
        $qu = new QueryUpdate("learning_step_audit", "id=int:id");
        $qu->AddColumn("int:date_completed", $d1);
        $qu->Bind("id", $row['id']);

        $db->query($qu);
    }
}


$db->EnableTokenCheck();

DB_UPDATE_FILE
);


$migrations->Run('16_image_extensions.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

$db->AlterColumn('learning_certificate', 'file_ext', 'file_ext', 'INT NULL DEFAULT 0');
$db->AlterColumn('learning_path', 'image_ext', 'file_ext', 'INT NULL DEFAULT 0');
DB_UPDATE_FILE
);


$migrations->Run('17_object_code_statuses.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

$db->AddColumn('learning_object_code', 'date_end', 'INT NULL DEFAULT 0');
$db->AddColumn('learning_object_code', 'object_status', 'INT NULL DEFAULT 1');
DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('01.01');
