<?php
$_db_migration_to = '09.02'; // 5.1.0
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('20251219-remove-duplicate-event-records.php', <<<'DB_UPDATE_FILE'
<?php

/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

$db->DisableTokenCheck();

/**
 * This migration will remove duplicate training record entries for training events. See BT-5701
 *
 * For these events only one record is needed to say that the user attended the event, they can't attend the same
 * time-bound event multiple times.
 *
 * The initial query finds all records for the events aggregation that have duplicate entries, along with the
 * lowest ID for each set. The DELETE query deletes all the duplicates for a particular entry keeping the first
 * (lowest ID) record.
 *
 */


$aggregation_id = 113; // AGGREGATION_EVENTS

$query = 'SELECT MIN(id) as id, user_id, record_type, code_id, object_id, COUNT(id) as total FROM learning_record WHERE record_type = int:aggregation_id GROUP BY user_id, record_type, code_id, object_id HAVING total > 1;';

$results = $db->Query($query, $aggregation_id);

if ($results->hasData()) {
	$migrations->Log('Removing duplicate training event records.' );
} else {
	$migrations->Log('No duplicate training event entries found.');
}

while ($row = $results->FetchArray()) {
	$migrations->Log("Removing for user_id:{$row['user_id']}, object_id:{$row['object_id']}");
	$query = 'DELETE FROM learning_record WHERE user_id = int:user_id AND record_type = int:record_type AND object_id = int:object_id AND id != int:id;';
	$db->Query($query, $row['user_id'], $row['record_type'], $row['object_id'], $row['id']);
}

$db->EnableTokenCheck();



DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('09.02');
