<?php
// This file contains the database schema version 09.02
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
if ($migrations->GetVersion() > 0)
	throw new Exception("The database is already initialized");
//===========================================================================================

// learning_certificate
$table_descr = array(
	'id'	=>	"IDENTITY",
	'user_id'	=>	"INT NOT_NULL",
	'added_by'	=>	"INT NOT_NULL",
	'title'	=>	"VARCHAR(255) NULL",
	'valid_from'	=>	"INT_DATE NULL",
	'valid_to'	=>	"INT_DATE NULL",
	'license'	=>	"VARCHAR(255) NULL",
	'url'	=>	"VARCHAR(1024) NULL",
	'record_id'	=>	"INT NULL",
	'file_ext'	=>	"VARCHAR(5) NULL",
	'created_date'	=>	"INT_DATE NOT_NULL DEFAULT 0",
);

$db->CreateTable('learning_certificate', $table_descr, true);
$db->CreateIndex('learning_certificate', 'idx_record_id', 'record_id');



// learning_certificate_reminder
$table_descr = array(
	'id'	=>	"IDENTITY",
	'certificate_id'	=>	"INT NOT_NULL",
	'reminder_id'	=>	"INT NOT_NULL",
);

$db->CreateTable('learning_certificate_reminder', $table_descr, true);



// learning_object_code
$table_descr = array(
	'id'	=>	"IDENTITY",
	'aggregation'	=>	"INT NOT_NULL",
	'object_id'	=>	"INT NOT_NULL",
	'code_id'	=>	"INT NOT_NULL",
);

$db->CreateTable('learning_object_code', $table_descr, true);
$db->CreateIndex('learning_object_code', 'idx_aggr_object_id', 'aggregation', 'object_id');
$db->CreateIndex('learning_object_code', 'idx_aggr_code_id', 'code_id');



// learning_path
$table_descr = array(
	'id'	=>	"IDENTITY",
	'title'	=>	"VARCHAR(255) NULL",
	'description'	=>	"VARCHAR_MAX NULL",
	'code_id'	=>	"INT NOT_NULL DEFAULT 0",
	'needed_score'	=>	"INT NULL",
	'status'	=>	"INT NOT_NULL",
	'created_by'	=>	"INT NOT_NULL",
	'created_date'	=>	"INT_DATE NOT_NULL",
	'file_ext'	=>	"VARCHAR(5) NULL",
	'deadline'	=>	"INT NULL",
);

$db->CreateTable('learning_path', $table_descr, true);



// learning_path_enrollment
$table_descr = array(
	'id'	=>	"IDENTITY",
	'user_id'	=>	"INT NOT_NULL",
	'path_id'	=>	"INT NOT_NULL",
	'date_enrolled'	=>	"INT_DATE NULL",
	'date_completed'	=>	"INT_DATE NULL",
	'date_updated'	=>	"INT_DATE NULL",
	'deadline_reason'	=>	"VARCHAR_MAX NULL",
);

$db->CreateTable('learning_path_enrollment', $table_descr, true);
$db->CreateIndex('learning_path_enrollment', 'idx_user_path_id', 'user_id', 'path_id');



// learning_path_item
$table_descr = array(
	'id'	=>	"IDENTITY",
	'title'	=>	"VARCHAR(255) NULL",
	'description'	=>	"VARCHAR_MAX NULL",
	'req_level'	=>	"INT NOT_NULL",
	'code_id'	=>	"INT NOT_NULL DEFAULT 0",
	'score'	=>	"INT NOT_NULL DEFAULT 10",
	'item_order'	=>	"INT NOT_NULL",
	'created_by'	=>	"INT NOT_NULL",
	'created_date'	=>	"INT_DATE NOT_NULL",
	'path_id'	=>	"INT NOT_NULL",
);

$db->CreateTable('learning_path_item', $table_descr, true);
$db->CreateIndex('learning_path_item', 'idx_path_id', 'path_id');



// learning_qualification_code
$table_descr = array(
	'id'	=>	"IDENTITY",
	'code'	=>	"VARCHAR(255) NULL",
	'description'	=>	"VARCHAR(255) NULL",
);

$db->CreateTable('learning_qualification_code', $table_descr, true);



// learning_record
$table_descr = array(
	'id'	=>	"IDENTITY",
	'user_id'	=>	"INT NOT_NULL",
	'added_by'	=>	"INT NOT_NULL",
	'record_type'	=>	"INT NOT_NULL",
	'title'	=>	"VARCHAR(255) NULL",
	'description'	=>	"VARCHAR_MAX NULL",
	'record_date'	=>	"INT_DATE NULL",
	'provider'	=>	"VARCHAR(255) NULL",
	'status'	=>	"INT NOT_NULL",
	'created_date'	=>	"INT_DATE NOT_NULL DEFAULT 0",
	'code_id'	=>	"INT NULL",
	'object_id'	=>	"INT NULL",
);

$db->CreateTable('learning_record', $table_descr, true);



// learning_step_audit
$table_descr = array(
	'id'	=>	"IDENTITY",
	'user_id'	=>	"INT NOT_NULL",
	'step_id'	=>	"INT NOT_NULL",
	'date_completed'	=>	"INT_DATE NULL",
	'object_id'	=>	"INT NOT_NULL",
	'aggregation'	=>	"INT NOT_NULL",
);

$db->CreateTable('learning_step_audit', $table_descr, true);
$db->CreateIndex('learning_step_audit', 'idx_user_step_id', 'user_id', 'step_id');
$db->CreateIndex('learning_step_audit', 'idx_user_id', 'user_id');
$db->CreateIndex('learning_step_audit', 'idx_step_user_id', 'step_id', 'user_id');





//===========================================================================================
$migrations->SetVersion('09.02');
