/**
 * Path status filter control.
 *
 * @author Simon Willan <simon.willan@claromentis.com>
 */
(function () {
	'use strict';

	angular.module('cla.reports.report')
		.directive('repPathStatusControl', repPathStatusControl);

	repPathStatusControl.$inject = ['$timeout'];

	function repPathStatusControl($timeout) {
		var directive = {
			bindToController: true,
			controller: controller,
			controllerAs: "filter",
			restrict: 'E',
			scope: {
				args: '='
			},
			templateUrl: '/intranet/learning/html/tmpl/reports/filters/path_status.html'
		};

		return directive;
		//////////////////


		/** directive controller */
		function controller($scope, $element) {
			var ctl = this;

			ctl.change = change;

			ctl.lmsg = {
				placeholder: lmsg('learning.path.status.select'),
				live: lmsg('learning.path.status_live'),
				archived: lmsg('learning.path.status_archived'),
				construction: lmsg('learning.path.status_under_construction')
			};

			ctl.options = [
				{ text: ctl.lmsg.construction, value: 1 },
				{ text: ctl.lmsg.live, value: 2 },
				{ text: ctl.lmsg.archived, value: 3 }
			];
			//////////////////

			init();

			function init() {
				ctl.args.operator = 'equals';
				
				$timeout(function () {
					$element.find("#statusFilter").val(ctl.args.values[0]).trigger("change");
				}, 0, true);
			}

			/** change event */
			function change(value) {
				ctl.args.operator = "equals";
				ctl.args.values[0] = value;
			}
		}
	}
}());
