/**
 * Step required filter control.
 *
 * @author Simon Willan <simon.willan@claromentis.com>
 */
(function () {
	'use strict';

	angular.module('cla.reports.report')
		.directive('repStepReqLevelControl', repStepReqLevelControl)

	repStepReqLevelControl.$inject = ['$timeout'];

	function repStepReqLevelControl($timeout) {
		var directive = {
			bindToController: true,
			controller: controller,
			controllerAs: "filter",
			restrict: 'E',
			scope: {
				args: '='
			},
			templateUrl: '/intranet/learning/html/tmpl/reports/filters/req_level.html'
		};

		return directive;
		//////////////////


		/** directive controller */
		function controller($scope, $element) {
			var ctl = this;

			ctl.change = change;

			ctl.lmsg = {
				placeholder: lmsg('learning.step.type.select'),
				mandatory: lmsg('learning.path_step.level_mandatory'),
				standard: lmsg('learning.path_step.level_common'),
				further: lmsg('learning.path_step.level_recommended')
			}

			ctl.options = [
				{ text: ctl.lmsg.mandatory, value: 1 },
				{ text: ctl.lmsg.standard, value: 2 },
				{ text: ctl.lmsg.further, value: 3 },
			];
			//////////////////

			init();

			function init() {
				$timeout(function () {
					$element.find("#typeFilter").val(ctl.args.values[0]).trigger("change");
				}, 0, true);
			}

			/** change event */
			function change(value) {
				ctl.args.operator = "equals";
				ctl.args.values[0] = value;
			}
		}
	}
}());