define(['jquery', 'cla_select2'], function ($) {

	return function () {

		var progress_tmpl = "";
		/**
		 * preload history template file
		 */
		$.get('/intranet/learning/html/tmpl/progress.html', {}, function (d) {
			progress_tmpl = d;
		});

		/*
		 * query-string utility
		 */
		function query_get(name) {
			name = name.replace(/[\[]/, "\\[").replace(/[\]]/, "\\]");
			var regex = new RegExp("[\\?&]" + name + "=([^&#]*)"),
				results = regex.exec(location.search);
			return results === null ? "" : decodeURIComponent(results[1].replace(/\+/g, " "));
		}

		/**
		 * helper to stop row collapsing on drag
		 */
		function fixHelper(e, ui) {
			var originals = ui.children();
			var helper = ui.clone();
			helper.children().each(function(index) {
				$(this).width(originals.eq(index).outerWidth());
			});
			return helper;
		}

		/**
		 * info about user enrolment
		 */
		function getJoinData(enrol_id)
		{
			$.get('/api/learning/join/'+enrol_id, {}, function (d)
			{
				if( d ) {
					if( d.notes ) {
						$("#assignment-notes").val(d.notes);
					}
					$("#jsConfirm-join").data('user', d.user);
					$("#jsWithdraw-join").data('enrol', enrol_id);
					$('#jsModal-join').modal('show');
					$("#jsWithdraw-join").show();
				}
			});
		}

		/**
		 * updates common list ajax
		 */
		function commonListUpdate(full_url, table_id)
		{
			var the_list = $("div#"+table_id);
			cla.CList.load(the_list, full_url, cla.CList.history_push);
		}

		/**
		 * tab learning
		 */
		var tab = query_get("tab");
		if (!tab) tab = 1;

		$("section.tab").hide();
		$("section.tab[rel='"+tab+"']").show();
		$("ul.nav-tabs li").removeClass("active");
		$("ul.nav-tabs li").eq(tab-1).addClass("active");

		/**
		 * hide show tabs for each section of view
		 */
		$("ul.nav-tabs li").on("click", function () {
			$("section.tab").hide();
			var tab = $(this).attr('data-id');
			$("section.tab[rel='"+tab+"']").show();

			$("ul.nav-tabs li").removeClass("active");
			$(this).addClass("active");

			return false;
		});

		/**
		 * join button clicked
		 */
		$("#jsJoin").on("click", function  ()
		{
			$("#assignment-notes").val('');
			$("#jsWithdraw-join").hide();

			var enrol_id = $(this).data("enrol");
			if (enrol_id) {
				getJoinData(enrol_id);
			} else {
				$("#jsModal-join").modal('show');
			}
		});

		/**
		 * sort the path step table
		 */
		$(".js-sortable-table tbody").sortable({
			helper: fixHelper,
			placeholder: "ui-state-highlight",
			forcePlaceholderSize: true,
			opacity: 0.7,
			revert: true,
			handle: '.sortable-icon',
			start: function (event, ui)
			{
				// create placeholder
				var columns = $(this).parent().find("thead tr").children().length;
				ui.placeholder.html('<td style="background: #fcf6c5;" colspan="' + columns + '">&nbsp;</td>');
			},
			update: function(event, ui)
			{
				// update sort orders
				var all = ui.item.parent().find("input");
				var orders = [];
				all.each(function(idx)
				{
					idx++;
					orders[idx] = $(this).val(); // item_id
				});

				// ajax sort order update
				$.ajax({
					type: "POST",
					url: '/api/learning/step_sort',
					data: JSON.stringify({steps:orders}),
					contentType: 'application/json'
				});
			}
		}).disableSelection();

		/**
		 * delete path step
		 */
		$("#jsPathSteps").on('click', '.js-delete-1', function () {
			$("#jsDelete-id").val($(this).data("id"));
			if( window.confirm(lmsg('learning.common.delete_confirm')) ) {
				$("#jsPathSteps").submit();
			}
			return false;
		});

		/**
		 * edit join path
		 */
		$("#jsParticipants").on('click', '.js-edit-1, .notes_expand', function () {
			var enrol_id = $(this).data("id");
			getJoinData(enrol_id);
			return false;
		});

		/**
		 * confirm join path
		 */
		$("#jsConfirm-join").on("click", function () {
			var path_id = $(this).data('path');
			var notes = $("#assignment-notes").val();
			var users = $("#joining_users").val();

			if( !users && $(this).data('user') ) {
				users = [];
				users.push( $(this).data('user') );
			}

			$.ajax({
				type: "POST",
				url: '/api/learning/join/'+path_id,
				data: JSON.stringify({notes:notes, users: users}),
				contentType: 'application/json',
				success: function (d)
				{
					if( d ) {

						$("#jsWithdraw-join").show();
						$("#jsWithdraw-join").data('enrol', d.enrol_id);
						$("#jsConfirm-join").data('user', null);

						if( d.progress )
						{
							$("#jsJoin").html(lmsg('learning.common.my_path'));
							$("#jsJoin").data('enrol', d.enrol_id);
							$("#js-modalTitle").text(lmsg('learning.common.my_path'));

							var progress = d.progress;
							$("#jsProgress-bar").removeClass("not-enrolled");

							var pass_percent = Math.floor(( progress.max > 0 ) ? (progress.pass / progress.max * 100) : 0);
							if (pass_percent > 100) pass_percent = 100;

							// fill template for each entry and append to DOM
							var item = _.template(progress_tmpl);
							$("#jsProgress-bar").html(item({
								score: progress.value,
								max: progress.max,

								text: lmsg('learning.path.your_progress'),
								points_text: lmsg('learning.path_step.label_points'),

								user_percent: Math.floor(( progress.max > 0 ) ? (progress.value / progress.max * 100) : 0),
								pass_percent: pass_percent,

								css: progress.passed ? progress.css : ''
							}));
						}
					}

					$("#jsModal-join").modal('hide');

					// update CommonListAjax
					commonListUpdate(window.location.href, 'participants_common_list_wrapper');
				}
			});
		});

		/**
		 * confirm withdraw user
 		 */
		$("#jsWithdraw-join").on("click", function () {
			var enrol_id = $(this).data('enrol');

			// ajax withdraw user
			$.ajax({
				type: "POST",
				url: '/api/learning/withdraw',
				data: JSON.stringify({enrol: enrol_id}),
				contentType: 'application/json',
				success: function (d)
				{
					$("#jsJoin").html(lmsg('learning.common.join_path'));
					$("#jsJoin").data('enrol', null);
					$("#jsConfirm-join").data('user', null);
					$("#js-modalTitle").text(lmsg('learning.common.join_path'));

					var pass_percent = Math.floor(( d.total > 0 ) ? (d.pass_mark / d.total * 100) : 0);
					if (pass_percent > 100) pass_percent = 100;

					// reset progress bar
					$("#jsProgress-bar").addClass("not-enrolled");
					var item = _.template(progress_tmpl);
					$("#jsProgress-bar").html(item({

						score: 0,
						max: d.total,

						text: lmsg('learning.path.progress_notice'),
						points_text: lmsg('learning.path_step.label_points'),

						user_percent: 0,
						pass_percent: pass_percent,
						css: 'not-enrolled'
					}));

					$("#jsModal-join").modal('hide');
					commonListUpdate(window.location.href, 'participants_common_list_wrapper');
				}
			});
		});

		/**
		 * delete participants
		 */
		$("#jsParticipants").on('click', '.js-delete-1', function () {
			$("#jsUserDelete-id").val($(this).data("id"));
			if( window.confirm(lmsg('learning.common.delete_confirm')) ) {
				$("#jsParticipants").submit();
			}
			return false;
		});

		/**
		 * hide other users feature on close
		 */
		$("#jsModal-join").on('hidden.bs.modal', function () {
			$("#user-panel").hide();
			$("#assignment-notes").val('');
			$("#jsWithdraw-join").hide();
			$("#joining_users").val('').trigger('change');
		});

		/**
		 * add other users to this path.
		 */
		$("#jsAdd-others").on('click', function () {
			$("#user-panel").show();
			$("#jsWithdraw-join").hide();
			$("#joining_users").val('').trigger('change');
		});

		$("#user-panel").hide();

		/**
		 * Delete confirmation for learning paths
		 */
		$("#jsDelete").on('click', function () {
			if( !window.confirm(lmsg('learning.common.delete_confirm')) ) {
				return false;
			}
		});
	};

});
