<?php
$_db_migration_to = '02.01';
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('01_modify_columns.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

// add columns

$db->AddColumn('learning_certificate', 'created_date', 'INT_DATE NOT_NULL DEFAULT 0');
$db->AddColumn('learning_record', 'created_date', 'INT_DATE NOT_NULL DEFAULT 0');
$db->AddColumn('learning_record', 'code_id', 'INT NULL');
$db->AddColumn('learning_record', 'object_id', 'INT NULL');
$db->AddColumn('learning_path', 'deadline', 'INT NULL');

// alter columns

$db->AlterColumn('learning_certificate', 'code', 'license', 'VARCHAR(255) NULL');

// drop columns

$db->DropColumn('learning_record', 'has_certificate');
$db->DropColumn('learning_path_enrollment', 'pulled_out');
$db->DropColumn('learning_path_enrollment', 'running_total');
$db->DropColumn('learning_object_code', 'code');
$db->DropColumn('learning_object_code', 'title');
$db->DropColumn('learning_object_code', 'date_end');
$db->DropColumn('learning_object_code', 'object_status');
$db->DropColumn('learning_path_enrollment', 'date_deadline');
DB_UPDATE_FILE
);


$migrations->Run('02_migrate_codes.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

/* ** migration function variable */
$migrate = function ($db, $result, $table, $column)
{
	$db->DisableTokenCheck();

	while ($row = $result->fetchArray())
	{
		if ($row['code_id'] != null)
			$query = new \Claromentis\Core\DAL\QueryUpdate($table, "id = int:id", array("str:{$column}" => $row['code_id']));
		else
			$query = new \Claromentis\Core\DAL\QueryUpdate($table, "id = int:id", array("str:{$column}" => 0));

		$query->Bind('id', $row['id']);
		$db->query($query);
	}

	$db->EnableTokenCheck();
};


/**
 * PATH CODE MIGRATION
 */
$qb = new \Claromentis\Core\DAL\QueryBuilder("SELECT a.id, b.id code_id FROM learning_path a");
$qb->AddJoin('a', 'learning_qualification_code', 'b', 'a.qualification = b.code');

$result = $db->query($qb->GetQuery());
$migrate($db, $result, "learning_path", "qualification");


/**
 * STEP CODE MIGRATION
 */
$qb = new \Claromentis\Core\DAL\QueryBuilder("SELECT a.id, b.id code_id FROM learning_path_item a");
$qb->AddJoin('a', 'learning_qualification_code', 'b', 'a.qualification = b.code');

$result = $db->query($qb->GetQuery());
$migrate($db, $result, "learning_path_item", "qualification");



/**
 * CERTIFICATE CODE MIGRATION
 * This needs more attention, certificates no longer have codes attached.
 */

$qb = new \Claromentis\Core\DAL\QueryBuilder("SELECT a.*, b.id code_id FROM learning_certificate a");
$qb->AddJoin('a', 'learning_qualification_code', 'b', 'a.qualification = b.code');

$result = $db->query($qb->GetQuery());

$db->DisableTokenCheck();

$now = new DateDay();

while ($row = $result->fetchArray())
{
	// do we have a code id?
	if ($row['code_id'] != null)
	{
		// do we have an attached record?
		if ($row['record_id'] != null)
		{
			$query = new \Claromentis\Core\DAL\QueryUpdate("learning_record", "id = int:id", array("str:code_id" => $row['code_id']));
			$query->Bind('id', $row['record_id']);
			$db->query($query);
		} else
		{
			// no record, create one for this certificate
			$insert_data = array(
				"int:user_id" => $row['user_id'],
				"int:added_by" => $row['added_by'],
				"int:record_type" => 115,
				"str:title" => $row['title'],
				"str:description" => "Auto Generated by Certificate",
				"int:record_date" => ( $row['valid_from'] ) ? $row['valid_from'] : $now->getDate(),
				"int:status" => 1,
				"int:created_date" => $now->getDate(),
				"int:code_id" => $row['code_id'],
				"int:object_id" => null
			);

			$query = new \Claromentis\Core\DAL\QueryInsert("learning_record", $insert_data);
			$db->query($query);

			// create connection between Record and Certificate
			$insert_id = $db->insertId();
			if ($insert_id)
			{
				$query = new \Claromentis\Core\DAL\QueryUpdate("learning_certificate", "id = int:id", array("int:record_id" => $insert_id));
				$query->Bind('id', $row['id']);
				$db->query($query);
			}
		}
	}
}

$db->EnableTokenCheck();

// drop code_id from Certificates
$db->DropColumn('learning_certificate', 'qualification');
DB_UPDATE_FILE
);


$migrations->Run('03_alter_code_columns.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

// add / alter / drop some columns
$db->AlterColumn('learning_path', 'qualification', 'code_id', 'INT NOT_NULL DEFAULT 0');
$db->AlterColumn('learning_path_item', 'qualification', 'code_id', 'INT NOT_NULL DEFAULT 0');
DB_UPDATE_FILE
);


$migrations->Run('04_alter_file_ext.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

/* ** Migration function variable */
$migrate = function ($db, $result, $table, $column)
{
	// file types from old system
	$ref_to_type = array(
		1 => "png",
		2 => "jpg",
		3 => "bmp",
		4 => "gif",
		5 => "tiff",
		6 => "pdf",
		7 => "jpeg",
		8 => "tif"
	);

	$db->DisableTokenCheck();

	while ($row = $result->fetchArray())
	{
		if ($row['file_ext'] != null)
		{
			if (isset($ref_to_type[$row['file_ext']]))
			{
				$new_ext = $ref_to_type[$row['file_ext']];
				$query = new \Claromentis\Core\DAL\QueryUpdate($table, "id = int:id", array("str:{$column}" => $new_ext));
				$query->Bind('id', $row['id']);
				$db->query($query);
			}
		}

	}

	$db->EnableTokenCheck();
};

$db->AlterColumn('learning_path', 'file_ext', 'file_ext', 'VARCHAR(5) NULL');
$db->AlterColumn('learning_certificate', 'file_ext', 'file_ext', 'VARCHAR(5) NULL');

/**
 * CERTIFICATE FILE EXTENSIONS
 */
$qb = new \Claromentis\Core\DAL\QueryBuilder("SELECT id, file_ext FROM learning_certificate");
$result = $db->query($qb->GetQuery());
$migrate($db, $result, "learning_certificate", "file_ext");


/**
 * PATH FILE EXTENSIONS
 */
$qb = new \Claromentis\Core\DAL\QueryBuilder("SELECT id, file_ext FROM learning_path");
$result = $db->query($qb->GetQuery());
$migrate($db, $result, "learning_path", "file_ext");
DB_UPDATE_FILE
);


$migrations->Run('05_update_admin_panel.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */
$admin_panel = $migrations->GetAdminPanelCreator();

// remove and recreate admin panel with new URL
$admin_panel->Create('learning', '../learning/admin_paths.php', array('name' => 'Learning', 'css_class' => 'glyphicons glyphicons-education'));
DB_UPDATE_FILE
);


$migrations->Run('06_map_type_ids.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

$query = new \Claromentis\Core\DAL\QueryUpdate("learning_record", "record_type = int:type", array("int:record_type" => 104)); // elearning
$query->Bind('type', 2);
$db->query($query);

$query = new \Claromentis\Core\DAL\QueryUpdate("learning_record", "record_type = int:type", array("int:record_type" => 113)); // events
$query->Bind('type', 1);
$db->query($query);

$query = new \Claromentis\Core\DAL\QueryUpdate("learning_record", "record_type = int:type", array("int:record_type" => 115)); // records
$query->Bind('type', 3);
$db->query($query);

$query = new \Claromentis\Core\DAL\QueryUpdate("learning_record", "record_type = int:type", array("int:record_type" => 116)); // paths
$query->Bind('type', 5);
$db->query($query);

$query = new \Claromentis\Core\DAL\QueryUpdate("learning_record", "record_type = int:type", array("int:record_type" => 115)); // certificates
$query->Bind('type', 4);
$db->query($query);
DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('02.01');
