$(function () {

	/**
	 * edit a code
	 */
	$("form").on('click', '.js-dt-edit', function () {
		var code_id = $(this).data("id");

		$.get(api+'code/'+code_id, {}, function (d) {
			$("#code-name").val(d.code);
			$("#code-description").val(d.description);
			$("#jsConfirm").val(d.id);

			$("#jsModal-codes").modal('show');
		});

		return false;
	});

	/**
	 * delete a code
	 */
	$("form").on('click', '.js-dt-delete', function () {
		if (window.confirm(lmsg('learning.common.delete_confirm'))) {
			var code_id = $(this).data('id');

			$("#jsDelete").val(code_id);
			$("#jsCode-form").submit();
		}

		return false;
	});

	/**
	 * key check for code < 3 characters
	 */
	$("#code-name").on("keyup", function () {
		var code = $(this).val();
		if (code && code.length >= 3) {
			$('.js-code-name-group').removeClass('has-error');
			$(".js-code-error").hide();
		}
	});

	/**
	 * confirm code save
	 */
	$("#jsConfirm").on("click", function (e) {
		var code = $("#code-name").val();

		if (!code || code.length < 3) {
			$('.js-code-name-group').addClass('has-error');
			$(".js-code-error").show();
			e.preventDefault();

			return false;
		}
	});

	/**
	 * reset code form
	 */
	$("#jsModal-codes").on("hidden.bs.modal", function () {
		$("#code-name").val("");
		$("#code-description").val(""); []
	})
});