define(['jquery'], function ($) {
	return function () {

		var offset = 0,
			visible_total = 10,
			items_per_page = 10,
			history_item_tmpl = "",
			filter = 0;

		/**
		 * preload history template file
		 */
		$.get('/intranet/learning/html/tmpl/history_item.html', {}, function (d) {
			history_item_tmpl = d;
		});

		/*
		 * query-string utility
		 */
		function query_get(name) {
			name = name.replace(/[\[]/, "\\[").replace(/[\]]/, "\\]");
			var regex = new RegExp("[\\?&]" + name + "=([^&#]*)"),
				results = regex.exec(location.search);
			return results === null ? "" : decodeURIComponent(results[1].replace(/\+/g, " "));
		}

		/**
		 * Select a user to view
		 */
		$("#find-user-track" ).on("change", function(val) {
			if (parseInt(val.target.value) > 0) {
				window.location.href = "/learning/training-records?user=" + val.target.value;
			}
		});

		/**
		 * Filter by an aggregation type
		 */
		$(".js-stats-item-filter").on('click', function () {
			var type = $(this).data("type");
			$(this).removeClass('faded-bg', {duration: 200});

			// reset paging
			reset_paging(type);

			// toggle filter
			if (type === filter) {
				filter = 0;
				$("#jsHistory-list").html('');
				$(this).siblings().removeClass('faded-bg', {duration: 200});
			}
			else {
				filter = type;
				$(this).siblings().addClass('faded-bg', {duration: 200});
			}

			// ajax request
			get_history();
		});

		/**
		 * delete history item
		 */
		$("#jsHistory-list").on('click', '.js-delete-1', function () {
				if( window.confirm(lmsg('learning.common.delete_confirm')) ) {

				var type = $(this).data("type");
				$.ajax({
					type: "DELETE",
					url: '/api/learning/history/' + $(this).data("id"),
					data: JSON.stringify({type: type}),
					contentType: 'application/json',
					success: function (d) {
						if( d && d.deleted )
						{
							$(".record-timeline-item[data-id='"+d.deleted+"']").remove();

							cla.showMessage(lmsg('learning.record.deleted'));

							// update stats
							var $stats_total = $(".stats-item[data-type='" + type + "']").find(".jsStats-total");
							var total = parseInt($stats_total.html());
							if( $.isNumeric(total) ) {
								if( (total - 1) < 0 ) total = 0;
								$stats_total.html(-- total);
							}
						}
					}
				});
			}
			return false;
		});

		/**
		 * show more (paging) click
		 */
		$("#jsShow-more").on('click', function () {
			// increment page number
			offset += items_per_page;

			// get history items
			get_history(true);
		});

		/**
		 * Fetches history items
		 */
		function get_history(is_paging) {
			var user_id = query_get("user");

			// fetch history
			$.get('/api/learning/history/'+(user_id ? user_id : 0),
				{ start: offset, limit: items_per_page, filter: filter },
				function (d) {
					if( d ) {

						// if we're filtering, clear the template
						if (filter > 0 && !is_paging)
							$("#jsHistory-list").html('');

						for( var i in d.history )
						{
							var history = d.history[i];
							history.can_modify = d.can_modify;

							// fill template for each entry and append to DOM
							var template = _.template(history_item_tmpl);
							var item = get_template(template, history);

							$("#jsHistory-list").append(item);

							if (is_paging)
								visible_total ++;
						}

						// hide button if we max out
						if (visible_total >= d.total) {
							$("#jsShow-more").hide();
						} else {
							$("#jsShow-more").show();
						}
					}
				}
			);
		}

		/**
		 * Get item template
		 */
		function get_template(template, history) {
			return template({
				date: history.date,
				is_future: history.is_future ? "text-error" : "",

				title: history.title,
				can_modify: history.can_modify,
				view_link: '/learning' + history.view_link,
				edit_link: '/learning' + history.edit_link,
				code: history.code ? "("+history.code+")" : "",
				type: history.type,

				icon: history.icon,
				color: history.color,

				show_certificate: history.show_certificate ? "" : "hidden",

				data_id: history.id,
				data_type: history.type_id
			});
		}

		/**
		 * Reset paging variables
		 */
		function reset_paging()
		{
			offset = 0;
			visible_total = 10;
		}

	};
});