define(['jquery'], function ($) {

	return function () {

		/**
		 * show many users
		 */
		$("#jsManyUsers").hide();
		$('.js-toggle-users').on('click', toggleUsers);

		/**
		 * delete from within a Record or Certificate
		 */
		$("#jsDelete").on('click', function () {
			if( !window.confirm(lmsg('learning.common.delete_confirm')) ) {
				return false;
			}
		});

		/**
		 * toggle single or multi user
		 */
		function toggleUsers() {
			var isSingle = $(this).hasClass('js-single-user');
			$(this).addClass('active btn-success').siblings().removeClass('active btn-success').addClass('btn-secondary');
			$("#jsManyUsers").toggle(!isSingle);
		}

		/**
		 * multi users, users selected check.
		 */
		$("#jsSave").on("click", function () {

			if ($("#jsManyUsers").is(":visible") && $("#jsUserPicker").val() == null) {
				cla.showMessage(lmsg('learning.learning_record.no_users'), '', true);
				return false;
			}
		});

	};

});
