# Learning Change Log

## 5.1.0 - 22nd January 2026

### Bug fixes

- !45 BT-5701 Fixed attendance at training events creating multiple training records

### Developer notes

- !45 BT-5701 Contains a migration that removes duplicate training records for training event attendance
    - Only the first attendance record will be kept, further entries for the same user/event will be removed

## 5.0.2 - 29th October 2025

### Improvements

- !42 FRAM-1067 updated component library usages for accessibility

## 5.0.1 - 16th June 2025

### Developer notes

- Merged upstream changes from 4.0.10

## 5.0.0 - 9th June 2025

- Stable release

## 5.0.0-beta2 - 19th May 2025

- Merged upstream changes from 4.0.9

## 5.0.0-beta - 16th April 2025

- 60a3677a BT-5201 Fixed a PHP 8 incompatibility error, caused by Learning configuration, when creating new Quizzes
- a39c8065 FRAM-1053 Fixed PHP 8 incompatibilities reported by PHPCS

## 5.0.0-alpha - 14th November 2024

- FRAM-954 Claromentis 10 compatibility

## 4.0.10 - 16th June 2025

### Improvements

- !44 LMS-228 Disco 048919 Introduced OpenAPI in 3.1 specification for documenting the REST API (training record)

## 4.0.9 - 19th May 2025

### Bug fixes

- !43 BT-5336 Added missing localisations for the Edit and Delete buttons in training records

## 4.0.8 - 18th October 2024

### Bug fixes

- !41 BT-4867 Resolved an issue where the Learning Path cover image was not displaying correctly when using a signed URL.
- !40 BT-4805 Disco 046369 Fixed metadata training record alignment issue in Learning

## 4.0.7 - 29th July 2024

### Improvements

- !39 LEAR-4 Disco 046023 Added a confirmation step for deleting a learning path to prevent accidental deletions.

### Developer notes

- Merged upstream changes from 3.4.5

## 4.0.6 - 19th June 2024

### Improvements

- !37 BT-4696 French localisation update
- !36 BT-4684 German localisation update

## 4.0.5 - 21st March 2024

- !35 BT-4580 Disco 044866 Fixed an error that occurred when attempting to add or edit an image for Learning Paths

## 4.0.4 - 15th March 2023

- Merged upstream changes from 3.4.4

## 4.0.3 - 28th February 2023

### Bug fixes

- 5fc4c49b BT-3820 Fixed issue with training records had two sets of edit and delete controls 

## 4.0.2 - 1st December 2022

### Improvements

- !31 BOOTY-582 Replaced utility classes usages with Bootstrap 4 standard utility classes
- FRAM-838 Added menu item registration

### Bug fixes

- !30 BT-3457 Fixed error message when trying to upload PDF file into certificates
- !32 BT-3800 Fixed error which occurs when user is adding a certificate to a training record

## 4.0.1 - 5th August 2022

### Improvements

- f9ae7a55 BOOTY-502 Updated Learning card background colour for reports module
- FRAM-657 Updated Reports Schema icon from Glyphicon to SVG
- FRAM-471 Declared support for PHP 8.1

### Developer notes

- FRAM-657 Moved `APPLICATION_SVG_URL` constant from `Claromentis\Learning\Provider\ServiceProvider` to `Claromentis\Learning\Plugin`
- Removed `config_learning.php` from repository

## 4.0.0 - 17th June 2022

* Stable release
* Merged upstream changes from 3.4

## 4.0.0-beta - 25th February 2022

### New features

* Claromentis 9 compatibility

### Bug fixes

* !24 BOOTY-399 Claromentis 9 QA bugfixes

## 3.4.5 - 25th July 2024

### Bug fixes

* !38 BT-4751 Disco 045728 Fixed slow loading on the page Learning path

## 3.4.4 - 15th March 2023

### Improvements

* !33 LEAR-1 Disco 040079 Added new event for overriding certificate downloads

### Developer notes

* !33 LEAR-1 Disco 040079 Added new `learning.certificate_download` event for overriding certificate downloads

## Version 3.4.3 - 8th April 2022

### Bug Fixes

* !29 BT-3238 Fix Training record not showing Learning Path completed if a user completes steps first and join to Learning Path after

## Version 3.4.2 - 24th February 2022

### Bug Fixes

* !28 BT-3035 Fix training record metadata not being shown in the training record report

## 3.4.1 - 27th January 2022

### Bug Fixes

* !25 PPS-216 Added a new parameter `width` to the QCodePicker component
* !27 PPS-218 Fixed narrow Qualification code field when editing training record or learning path

## 3.4.0 - 28th June 2021

### Bug fixes

* !23 BT-2551 Updated Training Record Bulk import to no longer fail to recognise Completion Dates when the Core
  configuration `cfg_date_format` `short_date` did not equal `d-m-Y`.

### Breaking changes

* Updated Core compatibility to `>=8.10`.

## 3.3.21 - 1st April 2021
* 948783b8 Deferred audit subscriber registration to avoid database usage on application boot
* !21 BT-2313 (Disco 32163) Fixed filtering by qualification code in the training records

## 3.3.20 - 8th February 2021

* !19 (BT-2183) Importing a training record CSV where some of the record IDs were left blank now works and treats them as new records (this is a fix for an accidental behaviour change)
* !20 BT-2214 (Disco 31544) Fixed error on submit when uploading invalid file type for learning certificate

## 3.3.19 - 18th December 2020
* !17 BT-2146 (Disco 30561) Fixed line breaks being stripped out when displaying descriptions for training records, learning paths and learning path steps
* !18 BT-2147 (Disco 30766) Fixed issue with completion date column in training record (value was always current date) 

## 3.3.18 - 2nd November 2020
* !16 BT-2048 (Disco 29687) Fixed creating a training record for multiple users not creating them correctly. Created records will now always show on a learning path page.

## 3.3.17 - 05th October 2020
* !15 BT-2022 Attempting to create a new Qualification Code after opening the editor for an existing Qualification Code will no longer update the existing Qualification Code, rather than creating a new one.

## 3.3.16 - 24th July 2020
* !14 BT-1852 (Disco#028970) Fixed error in calculating which tab to display on Path View.

## 3.3.15 - 12th February 2020
* !13 BT-1070 (Disco 026482) Fixed fatal formatting error when Training Records contained badly formatted record dates 

## 3.3.14 - 27th November 2019
* CORE-1036 Added Hungarian translation

## 3.3.13 - 1st November 2019
* !12 (BT-855) Users can no longer create Qualification Codes with duplicate Names.

## 3.3.12
* Added Uzbek translation

## 3.3.11
* (UIUX-475) Localisation improvements when creating new learning path.
* Fixed PHP 7.2 Countable incompatibility

## 3.3.10
* Added Russian translations and twig templates

## 3.3.9
* !10 Added REST API endpoints for adding and editing qualification codes

## 3.3.8
* Courses with a required score of 0 can now be classed as complete (DISCO 021220)
* Localisation for module name in admin panel and application menu

## 3.3.7
* Fullscreen or widescreen compatibility
* Fix issue with cropped image not being displayed when creating a certificate

## 3.3.6
* Fixed problem where newly created certificate was not being assigned to the user associated with its record (#416)

## 3.3.5
* Fixed Certificate Reminder notifications
* Renamed the User ID and Username Training Record Report columns to Id and Name (#397)
* Fixed date formatting for Training Record Reports (#396)
* Fixed an unintended redirect in the Qualification Codes Admin Panel (#395)
* Fixed undefined variable warning when CSV exports resulted in empty files
* Fixed localization breaking the CSV import/export process (#398, #454)
* Set a hard limit of 1,000,000 step point to help prevent overflows (#445)
* Added a validation check for the Record ID field when importing bulk Training Records

## 3.3.4
* Removed training record fallback

## 3.3.3
* Compatibility with Claromentis 8.3 and 8.2
* Fixed extra spaces causing error during csv import (Disco 19144)
* Added some missing German translations
* Added extra validation for dates when exporting data to CSV
* Modernised layout of admin pages

## 3.3.2
* Fixed an infinite loop in learning paths when certain permissions are in effect (Disco 19131, LEAR-212)

## 3.3.1
* Fix error where deadline date could not be created due to US date formatting (Disco 18903, LEAR-206)
* fix metatada not showing up in training report (Disco 18633)
* Removed new row every 4 paths (LEAR-195)
* Added permission check for Qualification Codes admin data source.
* Added permission check to Training Record Reports data source.

## 3.3.0
* No branch changes since RC
* Merged forward Learning v3.2.2

## 3.3.0-rc2
* Bug fixes (LEAR-191, LEAR-199, LEAR-200, LEAR-204)

## 3.3.0-rc
* Compatibility with Claromentis 8.2
* Made statistics click-able filters for Training Records
* Many Jira bug fixes

## 3.2.2
* Fixed text area display issues
* Fixed incorrect text for join and manage path modals
* Fixed unescaped Record and Certificate titles in Training History
* Fixed issue with icon sizing in tables
* Merged forward from 3.1.7
  * Fixed another potential fatal error in the case that a Learning Path's
    Qualification Code somehow no longer exists (Disco 017192)

## 3.2.2-rc
* Implemented Qualification Code permissions
  * Learning Administrators can now set permissions for who is able to create
    Qualification Codes
  * Replaced the admin panel's Qualification Code UI with DataTables
* Implemented Certificate Reminders
  * Learning Administrators can configure reminder notifications that will be sent
    prior to a Certificate's Valid-To date (expiry date)
  * Notifications can optionally be sent to a selection of users other than the
    Certificate owner
  * Notifications will be sent at 8AM every day
* Refactored the config service to use a the improved Config factory provided by core
* Merged forward from 3.1.6
  * Fixed showing record creation dates instead of their completion dates in
    Training Record Reports (Disco 016314).

## 3.2.1
* Compatibility fixes for PHP7 and Reports 1.2.0
* Integration improvements for the Quiz module (styling to be externalised later on)
* Design tweaks when viewing Training Records and Certificates
* Temporary implementation to support external modules setting their own descriptions
* Merged forward from 3.1.4
  * Fixed a potential fatal error in the case that a Learning Path's
    Qualification Code somehow no longer exists (Disco 015887)

## 3.2.0
* Compatibility with Claromentis 8.1
* Multiple bug fixes as found in Jira:
	* LEAR-11, LEAR-19, LEAR-101, LEAR-105, LEAR-108, LEAR-109, LEAR 116, LEAR-117, LEAR-118, LEAR-119

## 3.1.9
* Fixed metadata now working on reports (Disco 018633)

## 3.1.8
* Fixed common list loading ajax reload issue
* Fixed participants tab not displaying content to Manage Participant users (Disco 017929)
  
## 3.1.7
* Fixed another potential fatal error in the case that a Learning Path's
  Qualification Code somehow no longer exists (Disco 017192)

## 3.1.6
* Fixed showing record creation dates instead of their completion dates in
  Training Record Reports (Disco 016314)

## 3.1.5
* Fixed a PHP7 and Reports 1.2.0 incompatibility (String class)

## 3.1.4
* Fixed a potential fatal error in the case that a Learning Path's
  Qualification Code somehow no longer exists (Disco 015887)

## 3.1.3
* Added separate permissions for accessing reports

## 3.1.2
* Implemented Training Record Metadata support for Reports module
* Implemented Training Record Type Filter for Reports module

## 3.1.1
* Added German translation

## 3.1.0
* Support for Reports Engine

## 3.0.0
* All major bugs fixed wth Claromentis 8 compatibility
* No new features
* Better cohesion with external modules
* Claromentis 8 compatibility

## 2.1.2
* Implemented a migration to clear certificates attached to non-existent training records
* Fixed issues with JavaScript localization
* Fixed issues with REST API permission checks

## 2.1.1
* Fixed an error with metadata only displaying if type is record only

## 2.1.0
* Implemented "view subordinate training records" permission
* Fixed an error in the REST API preventing the "show more" button working for
  training record history

## 2.0.12
* Fixed permission checks for subordinates on training records.
* Fixed paging in Learning report page.

## 2.0.11
* Improvements to training record metadata code, for LMS Courses.
* Changed the way Learning object types are interally registered.

## 2.0.10
* Fixed more issues with certificates user IDs.
* Fixed sorting report items by date.

## 2.0.9
* Fixed double-encoded training record titles on the history page.

## 2.0.8
* Fixed certificate download button missing on record pages when no image has
  been uploaded.
* Fixed certificates saving with incorrect user IDs when saved by another user.

## 2.0.7
* Fix: Integrity check on headers of bulk CSV are a little less zealous. Header rows now get through fine.
* Fix: Added naive paging to reports for post filtered content.
* Known Issue: One extra page seems to occasionally show.
* Known Issue: Paging seems to forget TYPE filter.

## 2.0.6
* Added record metadata to training record reports.
* Added CSV download button to training record history page.

## 2.0.5
* Changed notification message internal ID as it was conflicting with other application
* Fixed saving records and certificates to incorrect users when editing them

## 2.0.4
* Fixed inconsistent dates format in the database, causing some dates to show incorrectly

## 2.0.3
* Added columns validation for CSV import
* Data cleanup when user is deleted from the system
* Displying Learning information on user's profile

## 2.0.2
* Various UI fixes
* Better handling of qualification code changes
* Support for backdated events

## 2.0.1
* Fix: A couple of namespace references to classes were missing causing an error upon deleting a Path Step.
* Fix: Added a migration script that cleans up Events in the object to codes table. Events moved from Event ID to Sequence ID.

## 2.0.0
* Refactor: All code has been rewritten from the ground up. This version is far more stable, extendable and maintainable.
* Fix: Many bugs with link between external modules and Learning.
* Enhancement: Certificates no longer use Qualification Codes. This priority has shifted to Training Records only.
* Enhancement: Deadlines moved from a per user basis, to a per Path basis. (From the date of enrolment)
* Enhancement: Certificates list in the sidebar has been removed entirely.
* Enhancement: Adding a Path Step is now done via a separate page.

## 1.0.13
* Fix: Minor spelling corrections.
* Fix: Modified some namespaces.
* Fix: Removed globals from application_enter which caused errors on startup.

## 1.0.12
* Fix: Several MSSQL fixes where hasRows() was being called after a fetch() causing hasRows() to return 0.

## 1.0.11
* Fix: Consolidated ajax (xajax) requests for ease of access

## 1.0.10
* Fix: Minor text changes to CSV template.
* Fix: Edge case bug on Event Handling for incoming path_update events.

## 1.0.9
* Fix: Reporting stabilised to handle large data sets
* Fix: Reporting filtering switched to user FFControl rather than on update. This also fixes a paging filter reset issue
* Fix: Added an Index to Certificates table on Record ID column ^^ Helps to fix large sets of data being slow

## 1.0.8
* Fix: Training Records per page from 3 - 20

## 1.0.7
* Enhancement: Import / Export Training Records now includes UPDATE and DELETE functionality
* Fix: Repeatable meta data on Import / Export CSV now works
* Fix: Minor bug fixes

## 1.0.6

## 1.0.5
* Enhancement: Added migration support from LMS Courses to Training Records
* Change: Removed date restriction on Learning Records

## 1.0.4
* Enhancement: Added migration support from LMS Courses to Training Records
* Fix: Minor bug fixes

## 1.0.3
* Enhancement: Design overhaul courtesy of Alan Jenkins
* Feature: Added Meta Data to Training Records and exported/imported CSVs
* Fix: Errors with CSV import. CSV import made more robust
* Fix: Permission Class IDs modified
* Fix: View All permissions are no longer superseded by Add/Edit/Delete Records and are now independent of each other

## 1.0.0
* Initial Release
