<?php
$_db_migration_to = '02.03';
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('01_object_code_cleanup.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

$db->DisableTokenCheck();

// todo :: convert certificate IDs to Record IDs where valid. Remove any records not found with the same ID

$query = new \Claromentis\Core\DAL\Query("SELECT * FROM learning_object_code");
$results = $db->query($query);

$actions = array();
$ids_to_delete = array();

// read object_code records and find duplicates.
while ($row = $results->fetchArray())
{
	$key = $row['aggregation'] . "|" . $row['object_id'] . "|" . $row['code_id'];
	if (!array_key_exists($key, $actions))
	{
		$actions[$key] = $row['object_id'];
	} else
	{
		$ids_to_delete[] = $row['id'];
	}
}

// remove all duplicates
if ($ids_to_delete)
{
	$query = new \Claromentis\Core\DAL\Query("DELETE FROM learning_object_code WHERE id IN in:int:ids", $ids_to_delete);
	$results = $db->query($query);
}

// delete every record from learning_object_code with aggregation of 115. We will repopulate

$delete_query = new \Claromentis\Core\DAL\Query("DELETE FROM learning_object_code WHERE aggregation = 115");
$results = $db->query($delete_query);

$insert_query = new \Claromentis\Core\DAL\Query("INSERT INTO learning_object_code (aggregation, object_id, code_id) (SELECT 115, id, code_id FROM learning_record WHERE record_type = 115 AND code_id IS NOT NULL)");
$results = $db->query($insert_query);

$db->EnableTokenCheck();
DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('02.03');
