<?php
$_db_migration_to = '02.04';
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('01_event_id_to_sequence_id.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

$db->DisableTokenCheck();

// check to see if Events table exists
$table_exists = $db->query_row("SELECT COUNT(0) FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME = 'events_event'");
$table_exists = ( $table_exists && $table_exists[0] > 0 );

if ($table_exists)
{
	// delete all from learning_object_code with aggregation 113 (events)
	$db->query("DELETE FROM learning_object_code WHERE aggregation = 113");

	// re-establish connection all events with qualification codes. JOIN To qualification_codes is necessary only to gain
	// access to the qualification code_id.
	@$db->query("INSERT INTO learning_object_code (aggregation, object_id, code_id)
				(
					SELECT DISTINCT 113, a.sequence_id, b.id
					FROM
						learning_qualification_code b LEFT OUTER JOIN events_event a
					ON a.qualification_code = b.code
					WHERE a.qualification_code IS NOT NULL
				);");
}

$db->EnableTokenCheck();
DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('02.04');
