<?php
$_db_migration_to = '03.01';
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('01_cla8_admin_link.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */
$admin_panel = $migrations->GetAdminPanelCreator();

// update admin panel with new URL
$admin_panel->Create('learning', '/learning/admin/paths', array('name' => 'Learning', 'css_class' => 'glyphicons glyphicons-education'));

DB_UPDATE_FILE
);


$migrations->Run('02_cla8_admin_service.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */
$admin_panel = $migrations->GetAdminPanelCreator();

// update admin panel with new URL
$admin_panel->Delete('learning', true);

DB_UPDATE_FILE
);


$migrations->Run('04_all_date_migration_v2.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

$db->DisableTokenCheck();

/**
 * Fixing certificate dates
 */
$db->query("UPDATE learning_certificate SET created_date=valid_from WHERE created_date=0 OR created_date IS NULL");
$db->query("UPDATE learning_certificate SET created_date=created_date*1000000 WHERE created_date<99998877 AND created_date<>0");
$db->query("UPDATE learning_certificate SET created_date=int:today WHERE created_date=0 OR created_date IS NULL", Date::getNowTimestamp());


/**
 * Fixing other table dates
 */

$db->query("UPDATE learning_path SET created_date=created_date*1000000 WHERE created_date<99998877 AND created_date<>0");

$db->query("UPDATE learning_path_enrollment SET date_enrolled=date_enrolled*1000000 WHERE date_enrolled<99998877 AND date_enrolled<>0");
$db->query("UPDATE learning_path_enrollment SET date_completed=date_completed*1000000 WHERE date_completed<99998877 AND date_completed<>0");
$db->query("UPDATE learning_path_enrollment SET date_updated=date_updated*1000000 WHERE date_updated<99998877 AND date_updated<>0");

$db->query("UPDATE learning_path_item SET created_date=created_date*1000000 WHERE created_date<99998877 AND created_date<>0");


$db->query("UPDATE learning_record SET created_date=created_date*1000000 WHERE created_date<99998877 AND created_date<>0");


$db->query("UPDATE learning_step_audit SET date_completed=date_completed*1000000 WHERE date_completed<99998877 AND date_completed<>0");

$db->EnableTokenCheck();

DB_UPDATE_FILE
);


$migrations->Run('05_reinstall_plugin.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */

// re-add plugin to make sure it's installed when Claromentis is upgraded to 8
$plugins = $migrations->GetPluginsRepository();
$plugins->Add("learning", '\Claromentis\Learning\Plugin');

DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('03.01');
