<?php
$_db_migration_to = '03.02';
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('01_permissions_bit_shift_claro8.php', <<<'DB_UPDATE_FILE'
<?php
/**
 * @var $migrations \Claromentis\Setup\SetupFacade
 */
$database = $migrations->GetDb();

/**
 * This is a training records permissions migration.
 * 
 * See Claromentis\Learning\Permissions\RecordPermission for the constants.
 * 
 * This is the same as 02.18 but a check is made here to ensure that it 02.18
 * hasn't already been run.
 */

if (!$database->query("SELECT * FROM db_migrations WHERE application = 'learning' AND file_name = '01_permissions_bit_shift.php'")->hasData())
{
	// Left shift all permissions
	$database->query('UPDATE permissions SET rights = rights * 2 WHERE class_id = 112');
	
	// Add PERM_VIEW_SUBORDINATE to all permissions except PERM_ADD_SELF
	$database->query('UPDATE permissions SET rights = rights + 1 WHERE class_id = 112 AND rights != 4');
	
	// Remove the PERM_VIEW bit (view all training records) from PERM_ADD_SUBORDINATE
	$database->query('UPDATE permissions SET rights = rights - 2 WHERE class_id = 112 AND rights = 15');
} else
{
	echo "Skipped 03.02 permissions bit shift as 02.18 has already been executed\n";
}

DB_UPDATE_FILE
);


$migrations->Run('02_drop_lms_migrated.php', <<<'DB_UPDATE_FILE'
<?php
/**
 * @var $migrations \Claromentis\Setup\SetupFacade
 */
$database = $migrations->GetDb();

$database->DropTable("learning_migrated");
DB_UPDATE_FILE
);


$migrations->Run('03_orphaned_certificates.php', <<<'DB_UPDATE_FILE'
<?php
/**
 * @var $migrations \Claromentis\Setup\SetupFacade
 */
$database = $migrations->GetDb();

$database->query("DELETE FROM learning_certificate WHERE record_id NOT IN (SELECT a.id FROM learning_record a) AND record_id != 0");
DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('03.02');
