<?php
namespace Claromentis\Learning;

$GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"] = (@$GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"] ?: array()) + array("_3fd2dd30151dfc8c00ac1ac" . "b5acd218e" => base64_decode("bGVhcm5pbmcuYWN0aW9uX2" . "RlbGV0ZQ=="), "_699cd46f386ae197472" . "2616ce651a3a1" => base64_decode("YWdncmV" . "nYXRpb2" . "4="), "_0ea4e32b57963ac0cb3057e03e9" . "aef64" => base64_decode("aW" . "Q="));
use Claromentis\Core\Event\GenericEvent;
use Claromentis\Learning\Model\Action;
use Claromentis\Learning\Model\Certificate;
use Claromentis\Learning\Model\Record;
use Claromentis\Learning\Repository\AuditRepository;
use Claromentis\Learning\Repository\EnrollmentRepository;
use Claromentis\Learning\Repository\RecordRepository;
use Claromentis\Learning\Repository\StepRepository;
use Claromentis\Learning\Repository\ActionRepository;
use Claromentis\Core\Event\EventDispatcher;






class LearningPipeline
{
    
    
    protected $audit_repo;
    
    
    protected $step_repo;
    
    
    protected $record_repo;
    
    
    protected $enrollment_repo;
    
    
    protected $action_repo;
    public function __construct(AuditRepository $_6cd43abcdb7d524e8a1cad055d4fad0d, StepRepository $_9bafe366ad188eeacbf6e213fcdfead1, RecordRepository $_047f1795946530d4c4c2ce5953eb2f87, EnrollmentRepository $_0338e2d2205e1fd98a128b830cc6b6cc, ActionRepository $_af1d47c0334f18b3413fb064ce7cb976)
    {
        $this->audit_repo = $_6cd43abcdb7d524e8a1cad055d4fad0d;
        $this->step_repo = $_9bafe366ad188eeacbf6e213fcdfead1;
        $this->record_repo = $_047f1795946530d4c4c2ce5953eb2f87;
        $this->enrollment_repo = $_0338e2d2205e1fd98a128b830cc6b6cc;
        $this->action_repo = $_af1d47c0334f18b3413fb064ce7cb976;
    }
    
    
    
    
    
    
    
    
    public function SaveRecord(Record $record, Certificate $certificate = null)
    {
        $_4b5e91a0a6f7f822ac389ad9a3fb0ee2 = $this->record_repo->Save($record, $certificate);
        
        
        if ($record->GetCodeId()) {
            $this->SaveAudit($record);
        }
        return $_4b5e91a0a6f7f822ac389ad9a3fb0ee2;
    }
    
    
    
    
    
    
    public function SaveAudit(Record $record)
    {
        if (!$record->GetObjectId()) {
            return;
        }
        
        
        $_37b66c4d46ff3bc006adfc55fc9157ba = $this->step_repo->GetStepsByCode($record->GetCodeId());
        foreach ($_37b66c4d46ff3bc006adfc55fc9157ba as $step) {
            $_838a57845905ef754a78964847aa779d = $this->audit_repo->BuildAudit($record, $step);
            $user_id = $_838a57845905ef754a78964847aa779d ? $_838a57845905ef754a78964847aa779d->GetUserId() : $record->GetUserId();
            if ($_838a57845905ef754a78964847aa779d) {
                $this->audit_repo->Save($_838a57845905ef754a78964847aa779d, $step->GetPathId());
            }
            $this->UpdateEnrollment($user_id, $step->GetPathId());
        }
    }
    
    
    
    
    
    
    
    public function UpdateEnrollment($user_id, $path_id)
    {
        if ($path_id) {
            $this->enrollment_repo->UpdateEnrollment($path_id, $user_id);
        }
    }
    
    
    
    
    
    
    
    public function DeleteRecord(Record $record)
    {
        $_4b5e91a0a6f7f822ac389ad9a3fb0ee2 = $this->record_repo->Delete($record);
        if ($record->GetCodeId()) {
            $this->DeleteAudit($record);
        }
        return $_4b5e91a0a6f7f822ac389ad9a3fb0ee2;
    }
    
    
    
    
    
    public function DeleteAudit(Record $record)
    {
        
        
        $audits = $this->audit_repo->GetByObject($record->GetObjectId(), $record->GetTypeId(), $record->GetUserId());
        if ($audits) {
            foreach ($audits as $_5feede65e7cfe8f0b3d9854c0363d548) {
                $this->audit_repo->Delete($_5feede65e7cfe8f0b3d9854c0363d548);
            }
        }
        $this->DeleteActions($record->GetId());
    }
    
    
    
    
    
    
    public function DeleteActions($record_id)
    {
        
        
        $_fe441aa3ef350bfb1a1a1ad8520dd530 = new GenericEvent(null, array($GLOBALS["__65da1b1ec2d6653e" . "8a0ab7848e536215"]["_0ea4e32b57963ac0cb3057e03e9ae" . "f64"] => $record_id, $GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_699cd46f386ae1974722616c" . "e651a3a1"] => TypeStore::DEFAULT_TYPE));
        EventDispatcher::Shared()->dispatch($GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["_3fd2dd30151dfc8c" . "00ac1acb5acd218e"], $_fe441aa3ef350bfb1a1a1ad8520dd530);
    }
    
    
    
    
    
    
    
    
    public function ChangeAction(Action $_8e7f4b5c8440c0a24fb1b632eee28538, $code_id)
    {
        if ($_8e7f4b5c8440c0a24fb1b632eee28538->GetCodeId() != $code_id) {
            
            
            $audits = $this->audit_repo->GetByObject($_8e7f4b5c8440c0a24fb1b632eee28538->GetObjectId(), $_8e7f4b5c8440c0a24fb1b632eee28538->GetAggregation());
            foreach ($audits as $_5feede65e7cfe8f0b3d9854c0363d548) {
                $this->audit_repo->Delete($_5feede65e7cfe8f0b3d9854c0363d548);
            }
            
            
            $_c456c6b3886ed2803349248752fedd14 = $this->record_repo->GetByObject($_8e7f4b5c8440c0a24fb1b632eee28538->GetObjectId(), $_8e7f4b5c8440c0a24fb1b632eee28538->GetAggregation(), $_8e7f4b5c8440c0a24fb1b632eee28538->GetCodeId());
            
            
            $_8e7f4b5c8440c0a24fb1b632eee28538->SetCodeId($code_id);
            $this->action_repo->Save($_8e7f4b5c8440c0a24fb1b632eee28538);
            
            
            foreach ($_c456c6b3886ed2803349248752fedd14 as $record) {
                $record->SetCodeId($code_id);
                $this->SaveRecord($record);
            }
        }
        return $_8e7f4b5c8440c0a24fb1b632eee28538;
    }
}