define(['jquery', 'moment'], function ($, moment) {
	return function () {
		$('#valid_to').on('dp.change', function (event) {
			var afterToday = false;
			
			var value = $(event.target).val();
			
			if (value) {
				var date = new moment(value, cla_locale.date_format);
				
				afterToday = date.isAfter(new moment(), 'day');
			}
			
			$('.js-reminders, .js-reminders-permissions').toggle(afterToday);
		}).trigger('dp.change');
	};
});
