define(['jquery', 'cla_select2'], function ($) {

	return function () {

		var $s2 = $("#qual_code_s2");

		var skip_codes = $s2.data("skip");
		skip_codes = skip_codes.toString().split(",");

		var hide_new = $s2.data("hide_new");

        var params = {
            placeholder: lmsg('learning.path_step.label_code'),
            minimumInputLength: 3,
            minWidth: 200,
            ajax: {
                url: '/api/learning/qualifications',
                quietMillis: 400,
                dataType: 'json',
                data: function (term, page)
                {
                    return { q:term.term, page_limit:20, page:page, skip: skip_codes, hide_new: hide_new };
                },
                processResults: function (data, params)
                {
                    var more = (params.page * params.page_limit) < data.total;
                    return { results:data.codes, more:more };
                }
            }
        };

        if ($s2.data("width"))
            params.width = $s2.data("width");

		$s2.select2(params);
	};
});
