<?php
$_db_migration_to = '12.01'; // 2.6.0
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('04_course_attempt_validity_column.php', <<<'DB_UPDATE_FILE'
<?php

/**
 * A **non-idempotent** migration for introducing the column `complete_attempt_validity_interval` to the table `lms_course`.
 *
 * Migrated months and years are converted into days to match the previous behaviour, where both were treated as a number of days.
 *
 * @var \Claromentis\Setup\SetupFacade $migrations
 * @throws Exception on failure.
 */

use Claromentis\Core\DAL;

$db = $migrations->GetDb();

// Add new column
if (!$db->AddColumn('lms_course', 'complete_attempt_validity_interval', 'VARCHAR(128) NULL DEFAULT NULL')) {
	throw new \Exception("Failed to add column 'complete_attempt_validity_interval' table 'lms_course'");
}

// Migrate existing data
$result = $db->query("SELECT id, validity_type, validity_value FROM lms_course WHERE validity_value <> 0");

while ($row = $result->fetchArray()) {
	$id           = (int)$row['id'];
	$validityType = (int)$row['validity_type'];
	$period       = (int)$row['validity_value'];

	/**
	 * Month unit.
	 * @see \LmsValidity::VALIDITY_MONTH
	 */
	if ($validityType === 1) {
		$days = $period * 30;
	}
	/**
	 * Year unit.
	 * @see \LmsValidity::VALIDITY_YEAR
	 */
	elseif ($validityType === 2) {
		$days = $period * 365;
	} else {
		$migrations->Log("Unrecognised Course $id Complete Attempt Validity Interval unit identifier $validityType. Course $id Complete Attempt Validity Interval will be set to null");
		continue;
	}

	$validity_interval = "P{$days}D";

	$db->query("UPDATE lms_course SET complete_attempt_validity_interval = str:validity_interval WHERE id = int:id", $validity_interval, $id);
}

// Delete old columns
$db->DropColumn('lms_course', 'validity_type');
$db->DropColumn('lms_course', 'validity_value');

DB_UPDATE_FILE
);


$migrations->Run('05_module_attempt_validity_column.php', <<<'DB_UPDATE_FILE'
<?php

/**
 * A **non-idempotent** migration for introducing the column `complete_attempt_validity_interval` to the table `lms_module`.
 *
 * Migrated months and years are converted into days to match the previous behaviour, where both were treated as a number of days.
 *
 * @var \Claromentis\Setup\SetupFacade $migrations
 * @throws Exception on failure.
 */

use Claromentis\Core\DAL;

$db = $migrations->GetDb();

// Add new column
if (!$db->AddColumn('lms_module', 'complete_attempt_validity_interval', 'VARCHAR(128) NULL DEFAULT NULL')) {
	throw new \Exception("Failed to add column 'complete_attempt_validity_interval' table 'lms_module'");
}

// Migrate existing data
$result = $db->query("SELECT id, validity_type, validity_value FROM lms_module WHERE validity_value <> 0");

while ($row = $result->fetchArray()) {
	$id           = (int)$row['id'];
	$validityType = (int)$row['validity_type'];
	$period       = (int)$row['validity_value'];

	/**
	 * Month unit.
	 * @see \LmsValidity::VALIDITY_MONTH
	 */
	if ($validityType === 1) {
		$days = $period * 30;
	}
	/**
	 * Year unit.
	 * @see \LmsValidity::VALIDITY_YEAR
	 */
	elseif ($validityType === 2) {
		$days = $period * 365;
	} else {
		$migrations->Log("Unrecognised Module $id Complete Attempt Validity Interval unit identifier $validityType. Module $id Complete Attempt Validity Interval will be set to null");
		continue;
	}

	$query = new DAL\QueryUpdate(
		'lms_module',
		'id = int:id',
		['str:complete_attempt_validity_interval' => "P{$days}D"]
	);
	$query->bind('id', $id);
	$db->query($query);
}

// Delete old columns
$db->DropColumn('lms_module', 'validity_type');
$db->DropColumn('lms_module', 'validity_value');

DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('12.01');
