<?php
$_db_migration_to = '13.05'; // 3.0.6
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('01_lmslrs-value-column-to-clob.php', <<<'DB_UPDATE_FILE'
<?php

/**
 * Migration reapplied from:
 * - 59094e54a9d699fbd3d765c71c163c3b071b7861
 * - LMS 2.5.10
 * - !58 BT-2988
 *
 * Altered to use `=` instead of `>=` for the deletion condition, to avoid deleting valid SCORM progress data
 */

/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

// Migration to fix truncated SCORM suspended attempt data in BT-2988 DISCO-34658

// change column from varchar(3000) to CLOB
$db->AlterColumn('lms_lrs', 'rec_value', 'rec_value', 'CLOB NULL');

// delete entries for SCORM suspended attempt data where the length is equal to 3000 chars,
// meaning it has almost certainly been truncated and prevent the user from continuing their
// attempt
if ($db->type() == 'mysql')
{
	$db->query("DELETE FROM lms_lrs WHERE rec_key = 'cmi.suspend_data' AND LENGTH(rec_value) = 3000");
} elseif ($db->type() == 'mssql')
{
	// MSSQL's LEN() function helpfully doesn't work with actual text columns, so
	// we have to use datalength instead which as it's an ascii text column will
	// equate to number of characters.
	$db->query("DELETE FROM lms_lrs WHERE rec_key = 'cmi.suspend_data' AND datalength(rec_value) = 3000");
}

DB_UPDATE_FILE
);


$migrations->Run('01_scorm_data_indexes.php', <<<'DB_UPDATE_FILE'
<?php

/**
 * Reapplied from !64 BT-621 from LMS 2.5.14
 */

/** @var \Claromentis\Setup\SetupFacade $migrations */
$migrations->getLogger()->warning('PLEASE NOTE: You may see "database index already exists" warnings in migrations that are about to run. This is expected!');

$db = $migrations->GetDb();

$db->CreateIndex('lms_lrs', 'idx_rec_key', 'rec_key(128)');
$db->CreateIndex('lms_lrs', 'idx_attempt_id', 'attempt_id');

DB_UPDATE_FILE
);


$migrations->Run('02_scorm_attempts_indexes.php', <<<'DB_UPDATE_FILE'
<?php

/**
 * Reapplied from !64 BT-621 from LMS 2.5.14
 */

/** @var \Claromentis\Setup\SetupFacade $migrations */

$db = $migrations->GetDb();

$db->CreateIndex('lms_lrs_attempts', 'idx_user_id_module_id', 'user_id', 'module_id');
$db->CreateIndex('lms_lrs_attempts', 'idx_complete', 'complete');

DB_UPDATE_FILE
);


$migrations->Run('03_scorm_data_indexes.php', <<<'DB_UPDATE_FILE'
<?php

/**
 * Reapplied from !64 BT-621 from LMS 2.5.14
 */

/** @var \Claromentis\Setup\SetupFacade $migrations */

$db = $migrations->GetDb();

$db->CreateIndex('lms_lrs', 'idx_attempt_id_rec_key', 'attempt_id', 'rec_key(128)');

DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('13.05');
