# LMS Change Log

## 4.1.0 - 3rd September 2025

### Developer notes

- Merged upstream changes from 3.4.0 and changed core version constraint to 10.1.3

## 4.0.2 - 3rd September 2025

### Bug fixes

- 9fdca67a...8e6c0ecc FRAM-1087 Fixed PHP 8 compatibility for migrations

## 4.0.1 - 4th July 2025

### Developer notes

- Merged upstream changes from 3.3.2

## 4.0.0 - 9th June 2025

### Developer notes

- Stable release
- Merged upstream changes from 3.3.0, 3.3.1

## 4.0.0-beta - 16th April 2025

- !119 FRAM-1040 Symfony 5 compatibility
- e52911b3 7f2a3ebd BT-5175 Fixed PHP 8 compatibility for Pages components
- Merged upstream changes from 3.2.0

### Developer notes

- Merged upstream changes from 3.1.3

## 4.0.0-alpha2 - 28th November 2024

- Merged upstream changes from 3.0

## 4.0.0-alpha - 14th November 2024

- FRAM-954 Claromentis 10 compatibility

## 3.4.0 - 3rd September 2025

### Improvements

- !132 BT-5400 Results in the course and module activity reports are now filtered if the user only has permission to view results for their own groups.

### Developer notes

- BT-5400 relies on a change in core to allow hiding the permissions picker in datatables and so requires core version 9.5.8 | 10.1.3.

## 3.3.2 - 4th July 2025

### Improvements

- !130 LMS-237 Hidden the unenrol option for users who are mandatory to enrol on a course

### Bug fixes

- !129 LMS-234 Disco-049497 Fixed a bug in module permissions admin panel where adding `Can Compete` permission automatically adds `Delete` to the module

## 3.3.1 - 5th June 2025

### Improvements

- !121 LMS-223 Disco 048267 Added new "Delete Course" and "Delete Module" admin permissions, separated from "Add Course" and "Delete Course"
- !126 LMS-224 Disco 048301 Removed permission `Public` from Permission Dialog

### Bug fixes

- !127 BT-5197 Fixed broken courses reports link in dropdown menu

## 3.3.0 - 20th May 2025

<!-- Minor release due to new features -->

### New features

- !122 PPS-247 Added support for contextual breadcrumbs and contextual redirects for Quiz's that are launched from LMS modules

### Developer notes

- !122 PPS-247 The merge request updated the quiz URL in the module (GET request) with query parameters that contain the module and course ID
- !122 PPS-247 The feature requires Quiz module in version `^3.1.0`

## 3.2.2 - 14th May 2025

### Bug fixes

- !124 LMS-230 Disco 047553 Added missing localisations for phrases related to module length

## 3.2.1 - 1st May 2025

### Bug fixes

- !123 BT-5307 Disco 049031 Fixed an issue where users who unenrolled from a course continued to receive module reminders

## 3.2.0 - 16th April 2025

<!-- Minor release due to new features -->

### New features

- !117 LMS-207 Implemented the option for administrators to manually complete modules on behalf other users

### Developer notes

- Merged upstream changes from 2.6

## 3.1.3 - 3rd December 2024

### Improvements

- !113 LMS-216 Fixed an intermittent issue where modules using some SCORM packages would not always be completed properly

### Bug fixes

- !106 LMS-213 Fixed Courses metadata display

## 3.1.2 - 28th November 2024

- !114 LMS-218 Added missing translation in French, German, Russian, Spanish related to Unenrollment feature

## 3.1.1 - 12th November 2024

- !112 LMS-215 Corrected German, French, and Spanish translation for In Progress status in LMS course audits

## 3.1.0 - 7th November 2024

<!-- Please remember to release a new MINOR version (e.g. 3.1.0) because this version contains a new feature -->

### New features

- !100 LMS-18 Disco 030501 Disco 031605 Disco 029602 Disco 037105 Add the ability to unenrol from a course

### Improvements

- !111 LMS-214 Added Course Unenrollment to the audit log

### Developer notes

- Merged upstream changes from v2.6

## 3.0.19 - 18th October 2024

### Bug fixes

- !110 BT-4376 Resolved an issue where HTML encodings were displayed for Group and Role names in LMS CSV reports for Courses and Modules.

## 3.0.18 - 18th September 2024

- Merged upstream changes from 2.6

## 3.0.17 - 11th September 2024

### Bug fixes

- f0b29403 Disco 046779 Fixed SCORM packages not loading correctly

## 3.0.16 - 3rd September 2024

### Improvements

- !96 LMS-92 Disco 045837 Added 2 new audit actions when a module is added or removed from a course

### Bug fixes

- !99 BT-4633 Fixed email reminder input alignment issue in LMS admin
- !105 LMS-92 Fixed module names not showing in audit logs for modules removed from courses

### Developer notes

- !105 Merged upstream changes from v2.6

## 3.0.15 - 26th June 2024

### Bug fixes

- !98 BT-4716 Disco 045702 Resolve the issue where the LMS SCORM package is loaded before the LMS API is ready.

## 3.0.14 - 19th June 2024

### New features

- !83 LMS-3 Disco 041081 Added the option for LMS admins to download a previously uploaded SCORM Package

### Improvements

- !94 BT-4696 French localisation update
- !92 BT-4684 German localisation update

### Developer notes

- Merged upstream changes from v2.6

## 3.0.13 - 2nd April 2024

- Merged upstream changes from 2.6.25

## 3.0.12 - 19th February 2024

- Merged upstream changes from 2.6

## 3.0.11 - 19th January 2024

- Merged upstream changes from 2.6.22, 2.6.23

## 3.0.10 - 30th November 2023

- Fixed fatal installation error
- FRAM-946 Further fixes for data directory permissions

## 3.0.9 - 30th November 2023

- Merged upstream changes from 2.6

## 3.0.8 - 16th November 2023

### Improvements

- !82 UIUX-862 Improved semantic heading title in LMS course and module
- Merged upstream changes from 2.6.20

## 3.0.7 - 16th June 2023

- Merged upstream changes from 2.6
- Compatibility for Claromentis Core 10

## 3.0.6 - 9th June 2023

- !58 BT-2988 !64 BT-621 Merged upstream changes from LMS 2.5

### Breaking changes

- !58 BT-2988 Merged forward a database migration from 2.5.10 that changes `lms_lrs.rec_value` column type from `VARCHAR` to `CLOB`

## 3.0.5 - 28th February 2023

- Merged upstream changes from 2.6

### Bug fixes

- !78 LMS-197 Fixed error message when adding SCORM packages to LMS modules

## 3.0.4 - 13th December 2022

### Bug fixes

- 961ea661 BT-3629 Updated courses reports display on tablets

### Improvements

- Merged upstream changes from 2.6
- LMS-193 Update full screen mode so it no longer uses a pop up when displaying Pdfs and Scorm
- FRAM-838 Added menu item registration
- 88a92441 BT-3829 Fixed oversight from LMS Full screen merge that caused the 'Open Quiz' button in the LMS page to be remove making it impossible to be navigate to a connected quiz

### Bug fixes

- 44f9b626 BT-3675 Fixed issue with course modules overview page displaying incorrectly on smaller viewports

## 3.0.3 - 14th October 2022

### Improvements

- FRAM-838 Implemented Composer autoloading for application constants

## 3.0.2 - 10th October 2022

### Improvements

- !74 BOOTY-582 Replaced utility classes usages with Bootstrap 4 standard utility classes

### Bug fixes

- Merged upstream changes from 2.6
- 10309cc6 BT-3568 Fixed issue with 'User/Group/Role' being squashed if they have no content in Course & Module reports
- b98175ea BOOTY-588 Fixed unattractive and inconsistent design and updated iconography on reports overview page
- !73 BOOTY-584 Fixed URL for Courses report

## 3.0.1 - 5th August 2022

### Improvements

- Merged upstream changes from 2.6
- f9c0a8bb BOOTY-500 Updated pages component IDs so they use the new class structure
 - BOOTY-515 Available Courses component
 - BOOTY-521 Courses Dashboard component
 - BOOTY-520 Completed Courses component
- e17769af BOOTY-502 Updated LMS card background colour for reports module
- 62d1860f BOOTY-425 Fixed issue with PDF certificate button having the old Glyphicons icon

## 3.0.0 - 30th June 2022

### Improvements

- FRAM-657 Updated Reports Schema icon from Glyphicon to SVG
- FRAM-471 Declared support for PHP 8.1

### Bug fixes

- 4c1e7c5c BOOTY-425 BT-3330 Fixed alignment issue with LMS modules which causes buttons to be squashed together
- fd63e71b BOOTY-425 Fixed issue with localisation not displaying correctly in LMS menus and minor alignment issues with checkboxes
- Fixed modules list not linking to modules properly (from b6177cf0)

### Developer notes

- FRAM-657 Moved `APPLICATION_SVG_URL` constant from `Claromentis\Lms\Provider\ServiceProvider` to `Claromentis\Lms\LmsPlugin`

## 3.0.0-beta2 - 11th April 2022

### Bug fixes

- 57a943a2 Fixed premature database connection from SCORM report service (`LrsMetricsVirtualTable`) 

### Merged forward from 2.5.10, 2.6.3, 2.6.4

- !62 FRAM-821 Disco 036352 Improved SCORM package file serving performance
- !63 BT-3322 Disco 036688 Fixed error when downloading CSV version of course audit reports for courses with mandatory users

#### Developer notes

- !62 LMS route registration has been moved from `LmsPlugin::boot()` time to `LmsPlugin::GetRoutes()` and `LmsPlugin::GetRestRoutes()`

## 3.0.0-beta - 25th February 2022

### New features

- Claromentis 9 compatibility

### Bug fixes

* FRAM-152 Fixed some cases where appdata directories would not be created at the correct path

### Developer notes

* FRAM-152 Updated module installation and uninstallation to use CDN interface for appdata directory creation and removal

## 2.6.32 - 18th December 2024

### Bug fixes

- !115 BT-5013 Fixed an error about missing import class `Claromentis\Core\Audit\Audit` during course enrollment

## 2.6.31 - 31st October 2024

## New features

- !104 LMS-208 LMS audit log - logging more actions from LMS

## 2.6.30 - 18th September 2024

### Bug fixes

- !101 LMS-201 Disco 045476 Course validity - added module's statuses check before changing LMS course status back to Enrolled
- !107 LMS-212 Disco 046644 Resolved the issue where SCORM videos were not playing in Safari.

## 2.6.29 - 3rd September 2024

### Bug fixes

- !102 LMS-209 Display Course and Module Name in the Audit Log
- !103 LMS-211 Fixed a browser compatibility issue with filters in Course reports and Module reports (`DOMNodeInserted` and `DOMNodeRemoved` event listeners have been replaced with the `MutationObserver` API)

## 2.6.28 - 25th June 2024

### Bug fixes

- !95 BT-4716 Disco 045702 Resolve the issue where the LMS SCORM package is loaded before the LMS API is ready.

## 2.6.27 - 12th June 2024

### Bug fixes

- !93 BT-4685 Fixed unescaped filenames for files uploaded as LMS module materials

## 2.6.26 - 29th May 2024

### Bug fixes

- !81 BT-4249 Disco 042863 Fixed double-encoded characters for Module titles in the Available Courses component
- !88 LMS-202 Disco 044557 Fixed permission checks for the retake course reminder notification and the review module notification

## 2.6.25 - 2nd April 2024

### Bug fixes

- !90 BT-4594 Disco 44895 Fixed an issue where the 'Available Courses' Page Component was not correctly sorting the Modules by their position
- !89 LMS-68 Disco 044789 Disco 044906 Fixed an issue in LMS modules using the SCORM 1.2 package that prevented users from navigating away.

## 2.6.24 - 19th February 2024

- !80 BT-4284 Fixed notifications for LMS Modules when using the default email reminder value
  - BT-4459 BT-4461 Improved email reminder error message when creating or editing LMS Modules
  - BT-4460 BT-4462 The default email reminder value in Courses preferences will now be set to a default value, `7`, when it has not yet been set by a user
- !87 BT-4475 Disco 44001 Disco 44276 Fixed SCORM modules not resetting progress when updating to a newer version

## 2.6.23 - 19th January 2024

### Bug fixes

- !85 BT-4361 Added a validation range to `Course Limit` (1 to 100) and `Module Limit` (0 to 100) for the LMS Dashboard component
- !85 BT-4362 Updated the LMS Dashboard component to include courses completed more than 2 weeks ago, as they were previously being filtered out

## 2.6.22 - 30th November 2023

- FRAM-946 Further fixes for data directory permissions

## 2.6.21 - 30th November 2023

### Bug fixes

- bce0fadd FRAM-946 Fixed insufficient data directory permissions during installation

## 2.6.20 - 16th November 2023

- !84 BT-4295 Disco-43157 Notification reminder to re-take module - added permission check if a user can view the LMS module

## 2.6.19 - 16th June 2023

- a5686b17 Updated PHP constraint to 7.4, up from 7.1

## 2.6.18 - 9th June 2023

- !79 BT-3834 Allowed a relative path to be added as URL in the LMS
- !58 BT-2988 !64 BT-621 Merged upstream changes from LMS 2.5

### Breaking changes

- !58 BT-2988 Merged-forward database migration from 2.5.10 changes `lms_lrs.rec_value` column type from `VARCHAR` to `CLOB`

## 2.6.17 - 24th February 2023

- LMS-189 Merged upstream changes from LMS 2.5

## 2.6.16 - 10th October 2022

### Bug fixes

- !76 BT-3581 Fixed XSS vulnerability in course completion notifications

## 2.6.15 - 15th September 2022

### Improvements

- !75 LMS-194 Improved SCORM package file handling and logging

### Bug fixes

- !72 BT-3566 Disco 038684, Disco 038648 Fixed SQL error when downloading the course audit report CSV for a course with a validity interval

## 2.6.14 - 25th August 2022

- 3a4dda3a ea80496b LMS-194 Fixed missing import statement for course attempt migration

## 2.6.13 - 23rd August 2022

### Bug fixes

- 651facda Fixed further possible incompatibility when running migrations on MSSQL servers

## 2.6.12 - 22nd August 2022

### Bug fixes

- !71 LMS-194 Fixed edge-case issue when loading SCORM package files under certain IIS configurations

## 2.6.11 - 17th August 2022

### Bug fixes

* !70 BT-3527 Fixed a possible incompatibility error in a migration when running on MSSQL servers

## 2.6.10 - 4th August 2022

* !16 BT-1190 Course Audit Report "Mandatory Courses Only" checkbox did not work as expected

## 2.6.9 - 21st July 2022

* Merged upstream changes from 2.5

## 2.6.8 - 23rd June 2022

### Merged forward from 2.5.11

#### Improvements

* !67 FRAM-800 wkhtmltopdf 0.12.6 compatibility

#### Developer notes

* !67 RD-31 Fixed SSRF vulnerability

## 2.6.7 - 17th June 2022

### Improvements 

- bfaf6a5e LMS-190 Changed the time that background reminder notifications are sent from 5am to 8am so we don't wake up sleeping users

## 2.6.6 - 10th May 2022

### Improvements

- !66 BT-3329 Edit module fixed deleting module in section Advanced rules

## 2.6.5 - 27th April 2022

### Improvements

- !65 LMS-189 Disco 036932 Improved performance for SCORM progress persistence

## Version 2.6.4 - 1st April 2022

### Bug fixes

- !63 BT-3322 Disco 036688 Fixed error when downloading CSV version of course audit reports for courses with mandatory users 

## Version 2.6.3 - 9th March 2022

### Merged forward from 2.5.10

- !62 FRAM-821 Disco 036352 Improved SCORM package file serving performance

#### Developer notes

- !62 LMS route registration has been moved from `LmsPlugin::boot()` time to `LmsPlugin::GetRoutes()` and `LmsPlugin::GetRestRoutes()`

## Version 2.6.2 - 16th December 2021

### Merged forward from 2.5.8, 2.5.9

#### Bug fixes

* !59 BT-2955 Potential fix for users who have taken a course being included in course audit reports but are missing from the CSV version of that report
* !60 PPS-216 Fixed too narrow Qualification Code field, when adding/editing Course (required Learning Module >= 3.4.1)

#### Developer notes

* !61 SDB0722 Added event dispatch (`"lms.course_completed"`) on Course completion.
* !61 SDB0722 Added `$course` entity as the subject of the `"learning.path_update"` event in `LmsCourseAudit`.

## Version 2.6.1 - 18th October 2021

### Merged forward from 2.5.7

#### Bug fixes

* !58 BT-2988 DISCO-34658 Added migration increase the size of the db column used to store partial SCORM attempts to fix a bug where attempt data was being truncated.

#### Breaking changes

* The fix for BT-2988 had to alter the type of the lms_lrs.rev_value database column, changing it from VARCHAR(3000) to CLOB. This shouldn't have any ill effects on anything using that table, but we're including it here as a potentially breaking change just in case of custom work we might not be aware of.

### Merged forward from 2.5.6

#### Bug fixes

* !57 LMS-70 Disco 034103 Fixed expired course attempts recompleting daily. Course attempts automatically recompleting will now update their completion dates properly.

## Version 2.6.0 - 10th September 2021

### New Features

* !46 LMS-128 Course and Module Complete Attempt Validity Intervals can now be defined in days.

### Improvements

* !46 LMS-128 Course and Module Complete Attempt Validity Intervals now observe calendar dates when expiring Attempts.

### Breaking Changes

* !46 LMS-128:
  * `\LmsObject`:
    * Removed public property `validity_type`.
    * Removed public property `validity_value`.
    * Removed method `SetValidityValue`.
    * Removed method `GetValidityValue`.
    * Removed method `SetValidityType`.
    * Removed method `GetValidityType`.
  * `\LmsAudit`:
    * Removed public property `validity_type`.
    * Removed public property `validity_value`.
  * `\LmsValidity`:
    * Removed method `GetValidityString`.
    * Removed method `GetValidityInDays`.
* Core compatibility changed to `>=8.13`.
* !48 LMS-146 Reports conflict changed to `<1.7.0`.

## 2.5.14 - 12th May 2023

### Improvements

- !64 BT-621 Improved performance of SCORM attempts reports in the Reports integration

## 2.5.13 - 19th October 2022

### Improvements

- !77 LMS-189 LMS-199 Disco 038903 Back-ported improved performance for SCORM progress persistence (course completion)

## 2.5.12 - 21st July 2022

* Fixed incompatibilities with the filesystem abstraction for the uninstallation script
* !68 BT-3329 Disco 038067 Back-ported Advanced Rules fixes from 2.6.6+

## 2.5.11 - 23rd June 2022

### Improvements

* !67 FRAM-800 wkhtmltopdf 0.12.6 compatibility

### Developer notes

* !67 RD-31 Fixed SSRF vulnerability

## Version 2.5.10 - 9th March 2022

- !62 FRAM-821 Disco 036352 Improved SCORM package file serving performance

### Developer notes

- !62 LMS route registration has been moved from `LmsPlugin::boot()` time to `LmsPlugin::GetRoutes()` and `LmsPlugin::GetRestRoutes()`

## Version 2.5.9 - 16th December 2021

### Bug fixes

* !60 PPS-216 Fixed too narrow Qualification Code field, when adding/editing Course (required Learning Module >= 3.4.1)

### Developer notes

* !61 SDB0722 Added event dispatch (`"lms.course_completed"`) on Course completion.
* !61 SDB0722 Added `$course` entity as the subject of the `"learning.path_update"` event in `LmsCourseAudit`.

## Version 2.5.8 - 5th November 2021

### Bug fixes

* !59 BT-2955 Potential fix for users who have taken a course being included in course audit reports but are missing from the CSV version of that report

## Version 2.5.7 - 8th October 2021

### Bug fixes

* !58 BT-2988 DISCO-34658 Added migration increase the size of the db column used to store partial SCORM attempts to fix a bug where attempt data was being truncated.

### Breaking changes

* The fix for BT-2988 had to alter the type of the lms_lrs.rev_value database column, changing it from VARCHAR(3000) to CLOB. This shouldn't have any ill effects on anything using that table, but we're including it here as a potentially breaking change just in case of custom work we might not be aware of.

## Version 2.5.6 - 26th August 2021

### Bug fixes

* !57 LMS-70 Disco 034103 Fixed expired course attempts recompleting daily. Course attempts automatically recompleting will now update their completion dates properly.

## Version 2.5.5 - 28th July 2021

### Bug fixes
* !54 BT-2552 Fixed filtering by course name in the course activity report
* !52 BT-2495 Fixed filtering by module name in the module report

## Version 2.5.4 - 12th July 2021

### Bug fixes

* !55 BT-2558 Courses and Modules with Tags containing apostrophes will no longer crash their relative tile lists.

### Developer Notes

* !55 BT-2558 Deleted `\LmsUtils::JSONEscape`.

## Version 2.5.3 - 01st April 2021

### Bug fixes
* !37 BT-2343 Course completion reminders should now be sent to all Users enrolled on a Course that haven't completed it, irrespective of whether the Course was 'mandatory' for them.

## Version 2.5.2 - 24th March 2021

### Bug fixes
* !35 BT-2288 The course module is now updating status if the user passed a quiz

## Version 2.5.1 - 05th March 2021

### Bug fixes
* !34 BT-2266 Fixed a potential SQL error in the migration "01_update_lms_material_document_id" that could occur if the application contained no module materials pointing to documents.

## Version 2.5.0 - 12th February 2021

### Improvements
* !32 BT-2224 Document Module Material will always return the latest version of the Document.

### Bug fixes
* !32 BT-2224 Adding a Document with multiple versions as a Module's Material will no longer result in the Document being unavailable to download from the Module.

### Breaking Changes
* !32 BT-2227 Method `\LmsMaterialDocument::GetDocument` can now throw Exception `\Claromentis\Lms\material\Exception\ERMSDataObjNotFoundException`.

## Version 2.4.19 - 12th February 2021

### Bug fixes
* 1974780c Fixed potential Core boot error when integrating with the Quiz module
* !33 BT-2217 Users whose couse enrolment is mandatory will be correctly identified when viewing the course audit.

## Version 2.4.18 - 26th January 2021

### Improvements
* !31 LMS-22 Scores from SCORM Package attempts are now captured.

## Version 2.4.17 - 19th november 2020

* !30 BT-2103 Fixed module description displaying all on one line

## Version 2.4.16 - 13th November 2020

* !27 LMS-9 New installs will set their 'Content view' as 'Embedded'
* !26 LMS-8 Hiding module cover image for small devices to improve mobile usability.
* !29 LMS-21 Display of unenrolledCourses in the Pages Component *Available Courses* is no longer affected by other User's enrolment.

## Version 2.4.15 - 4th November 2020

* PHP 7.4 compatibility fixes

## Version 2.4.14 - 23th September 2020

* !25 BT-1985 Fixed course completed date/time updating when viewing learning modules

## Version 2.4.13 - 16th September 2020

* !24 BT-1979 Fixed error preventing category names from being edited

## Version 2.4.12 - 20th August 2020
* !23 BT-1920 The title of the "Courses" area in Learning is now localised

## Version 2.4.11 - 12th August 2020

### Bug fixes
* !22 BT-1892 Blocked Users *completing* Courses will no longer generate a User Completed Course notification.
* !22 BT-1892 Random Users' Modules will no longer be moved from *completed* when any Users' Courses updates due to Course Validity.

## Version 2.4.10 - 13th July 2020

### Bug fixes

* !21 BT-1797 Users are now blocked from enrolling on Courses they're already enrolled on, or that have outstanding dependencies.

## Version 2.4.9 - 30th June 2020
* !20 BT-1798 Pages component didn't show enrolled learning modules in a list (Disco #027830) 

## Version 2.4.8 - 19th June 2020
* !18 BT-1625  Russian alphabet (Cyrillic) are now displayed correctly in E-learning certificate PDF Download.
* Added a "completed" label to courses in the main course list
* !19 BT-1765
  * Fixed certificate PDFs not being downloadable if language is set to Russian
  * Fixed seal sometimes not displaying in downloaded certificates

## Version 2.4.7 - 01st April 2020
* !17 BT-1345 Removed links on Blocked Users in Course and Module reports.

## Version 2.4.6 - 30th January 2020
* !14 CORE-1054 Added available courses component

## Version 2.4.5 - 27th January 2020
* !15 BT-1115 Fix brackets showing in title when no code is selected

## Version 2.4.4 - 20th December 2019
* Changes from 2.3.19

## Version 2.3.19 - 20th December 2019
* Restored missing "Send reminder" functionality.

## Version 2.4.3 - 20th December 2019
* !12 BT-1057 Fixed MSSQL issue with too many rows in course activity report

## Version 2.3.18 - 20th December 2019
* !11 CORE-796 Corrected audit CSV query building code for mandatory users.

## Version 2.4.2 - 27th November 2019
* CORE-1036 Added Hungarian translation

## Version 2.4.1 - 29th October 2019
* Added Uzbek translation

## Version 2.4.0 - 18th October 2019
* Core dependency updated **>=8.6**
### Improvements
* !10 CORE-973 Added Component `Completed courses` to Category `Learning & Knowledge Base`.
* !10 CORE-973 Added Component `Mandatory courses` to Category `Learning & Knowledge Base`.
* !10 CORE-974 Added Localized Titles to the following Components:
     * Completed courses
     * Mandatory courses

##Version 2.3.17 - 18th October 2019
* !9 Localisation improvements, updates to module status, new and updated course filters. (UIUX-475)

##Version 2.3.16  - 14th June 2019
* Fixed an issue with Greek translation strings that could display errors.

## Version 2.3.15
* !4 UIUX-404 Updated Admin templates to match the current design;
* !5 CORE-405 Introduced score column to modules report. This can be turned on or off in Courses admin Preferences.
* Added Russian translations and twig templates

## Version 2.3.14
* !8 CORE-218 Fixed admin users being able to enrol in course and set modules as completed without explicit permissions
* !7 CORE-695 PDF file upload Learning Material is now displayed within the page
* !7 CORE-695 Implemented the ability to disable downloads for web-supported images and PDF Learning Module file upload material from the
  preferences admin panel.

## Version 2.3.13
* Implemented the ability to disable downloads for embeddable video and audio Learning Module Materials from the
  preferences admin panel (CORE-587, UIUX-380)
* Improved UX and localization for the preferences admin panel

## Version 2.3.12
* Added pagination for SCORM summary on reports page in attempt to fix very slow page. (Disco 23338, CORE-612)
* Preventing download of video and audio in Chrome using attributes

## Version 2.3.11
* SUGRE picker was not syncing correctly on the course activity report filter. (#188, Disco 22217)

## Version 2.3.10
* Courses (e-learning) is now called Courses everywhere including in Search
* Increase the height of module embed SCORM view so that vertical scroll won't be displayed.
* Fix for scorm access bug (CORE-40)

## Version 2.3.9
* Localisation change to start referring e-learning (lms) to Courses
* Making layout when viewing a modules and courses more user friendly for large screen
* Moving tutor panel to the right side of the info panel (#198)
* Fixing Completed label and dummy date displayed when creating a new module (#199)
* Adding localisation to module info title (#196)
* Making tutor's avatar round or square depending what's set in design panel (#201)
* Fixing long course name causing overlap on browse module table (#185)

## Version 2.3.8
* Renamed "E-Learning Courses" to "Courses" for the Learning Homepage Card
* Improved breadcrumb consistency when listing, viewing, creating and editing Modules (#190)
* Ensured the the "Learning" application link in the breadcrumb is disabled if the Learning module is disabled (#191)

## Version 2.3.7
* Marked as compatible with future versions of Claromentis
* Fixed issue with View Certificate button being hidden behind course info
* Spelling fix UK Enrol and US Enroll #159, #164
* Fixed an issue with a select showing apartial placeholder. #179
* Added sanity check to list of courses to try and avoid error shown in issue #151

## Version 2.3.5 ##
* Fixed syntax when building SQL statement (#151)

## Version 2.3.4 ##
* Resolved git issues #154 and #153
* Resolved course audit bugs (Disco #019594)

## Version 2.3.3 ##
* Added some German translations (Disco #017837)
* Cleanup file fix

## Version 2.3.2 ## 
* Marked as compatible with Claromentis 8.3
* Fixed potential SQL error in mandatory courses report

## Version 2.3.1 ## 
* Fixed issue with html entities in notification subject lines (COUR-225)
* fix utf-8 issue with sort filter naming (COUR-29)
* Changed categories to category (COUR-224)
* Added a log of internal errors only visible when logs are turned on
* Added correct module link to module activity report (COUR-227)
* Add status name to course search in report (when not live) (COUR-228)
* Removed full stop from localised growl message (COUR-229)
* Added space between radio button for reminder types (COUR-230)
* Hide send reminder button if course is not live (COUR-231)
* Removed new line when no expected duration set in course reminders (COUR-223)
* Excluded drafts from Module Activity report too (COUR-213)
* Added localisation to audit and module browse table on course view page (COUR-217)
* Excluded drafts from course activity reports (COUR-213)
* Added mandatory users and no started status to audit CSV (COUR-216)
* Added formatting to groups and roles on CSV download (COUR-210)
* Fixed tooltips on group and role in datatable (COUR-211)
* Changed multi selects to multi select2 (COUR-212)
* Added time to mandatory course module for courses (as well as modules) (COUR-207)
* Added code to find users for notification
* Added a working reminder notification 
* Added mandatory users and checkbox column to Course Audit tab on Course View
* Fixed incorrect ID referencing module report form, caused console errors with perms dialog (COUR-209)

## Version 2.3.0 ##
* Compatibility with v8.2+
* Fixed a number of bugs from the Jira backlog
* Introduced some design layout changes to creating courses/modules
* Added support for video/audio files for Module Materials using HTML5
  video/audio tags

## Version 2.2.4 ##
* Fixed a number of bugs from the Jira Backlog
* Tidied up some code and fixed line-endings

## Version 2.2.3 ##
* Fixed an issue when interpreting SCORM score data
* Fixed a double drag and drop area issue
* Fixed an issue with the version number of the last release

## Version 2.2.2 ##
* Fixed a critical bug where a module could not be marked as completed
* Implemented the Quiz Learning Material type for improved integration with the
  Quiz module
* Merged forward from 2.1.3
  * Ensured that actions are removed from a path step if the course or dependent object
    has its qualification code removed

## Version 2.2.1 ##
* Visual fixes - new icon and better responsive UI
* Fixed String class, incompatible with PHP7
* Removed broken reference to calendar_inc in admin area

## Version 2.2.0 ##

* Compatibility with Claromentis 8.1
* Bug fixes as found in Jira:
	* COUR-108, COUR-123, COUR-129, COUR-135, COUR-137, COUR-139, COUR-142, COUR-146
* Removal of DataTable classes as they exist in Claromentis 8.1 directly

## Version 2.1.6 ##
* Fixed column length assumption in Metrics Virtual Table

## Version 2.1.5 ##
* Added German translations
 
## Version 2.1.4 ##
* Fixed condition check in scorm api (1.2) that was comparing strings rather than integers. Fixes issues with scorm overwriting old data.

## Version 2.1.3 ##
* Improved UI/UX and extranet visibility issues when adding and removing users
  from Group Mode Completion
* Ensured that actions are removed from a path step if the course or dependent object
  has its qualification code removed

## Version 2.1.2 ##

* Added missing German translations
* Datatable localization for the module's built in reports
* Fixed the inability to select users for Group Mode Completion
  * The code related to this needed to be updated to support Select2 4.0.1
* Updated & improved the Reports integration
  * Support for Reports 1.2.0+
  * Throttled the virtual table creation to bypass the INSERT limit on MySQL

## Version 2.1.1 ##

* Added support for SCORM reports to the Reports classes.

## Version 2.1.0 ##

* Removed RC flag.
* Fix : User picker only accepting a limited number of user ids due to request URI too long
* Fix : Administrators can no longer lock themselves out of modules and courses

## Version 2.1.0-rc ##
* Added support for SCORM tracking
* Updated reports pages to utilize new tracking capabilities

## Version 2.0.1 ##
* Added German translation

## Version 2.0.0 ##
* Compatibility with Claromentis 8.0
* Moved entire application into /learning/courses URL
* Fix: Further localization improvements
* Fix: Multiple minor improvements to functionality as per the existing issues list
* Fix: Form data retention when creating/editing courses/modules

## Version 1.12.0 ##
* New Feature: Training record metadata integration for LMS courses
* Fix: Localization improvements

## Version 1.11.5 ##
* Fix: Reminder notifications sending even when a course has been completed

## Version 1.11.4 ##
* Fix: SQL query on MSSQL in dashboard component
* Fix: error while sending course notification

## Version 1.11.3 ##
* Fix: A multitude of SCORM errors through a simple API fix
* Fix: Code review and cleanup

## Version 1.11.2 ##
* Minor Update: Added extra check on Save for users course completion. This updates Learning if any are found
* Fix: Fatal error on course complete. Using $audit instead of $course as $course doesn't exist in context.
* Fix: General fixes to Course and Module Audits

## Version 1.11.1 ##
* Fix: Minor bug fixes and issues from GitLab

## Version 1.11.0 ##
* Feature: Learning 1.x integration. 1.11.0 is now compatible with early versions of Learning.
* Fix: Global registration on application_enter causing errors.
* Fix: Removed permissions check on Application Enter to prevent database access. Added to each page independently.

## Version 1.10.0 ##
* Supported only in Claromentis 7.4 +
* Major Update: Integrated into global search

## Version 1.9.0 ##
* Supported only in Claromentis 7.3 +
* Major Update: Integrated support for Learning module
* Major Update: Integrated support for Symfony Event Dispatcher

## Version 1.8.4 ##
* Last stable version for Claromentis 7.2.
* Minor Update: Included instructions for installation
* Minor Update: Updated dashboard component styles
* Fix: Error in SCORM packages, DB Token check was not being disabled where needed and caused errors

## Version 1.8.3 ##
* Minor Update: Renamed LMS To E-Learning
* Fix: Templater localisation messages in PHP removed
* Fix: Minor style changes

## Version 1.8.2 ##
* Minor Update: Only tutors may now mark users as having completed a module under group mode completion
* Fix: Moved certificate creation to a temporary directory
* Fix: Deleting a prerequisite course no longer causes the prerequisite message to say 'hidden'
* Fix: Advanced rules on modules now clears the search word after selecting a module
* Fix: Major error with permissions on viewing a module now fixed. Introduced in 1.8.1
* Fix: CSV and Module audit showing date completed as the enrolled date
* Fix: Users with permission to view reports could also navigate to module or course without permission, although they would immediately get navigated away again

## Version 1.8.1 ##
* Fix: MSSQL error when viewing mandatory course report

## Version 1.8 ##
* New Feature: Module material file uploads via AJAX/CFUU for improved reliability
* Fix: Prevent fatal error when removing identical users in Group Mode Completion from different sessions
* Fix: Editing a module from Course Manage Modules no longer displays an error message
* Fix: Added a permissions check for course, module and mandatory reports pages
* Fix: Reminder/Validity Notifications only sent for modules when the module is assigned to a course
* Fix: Course create/update notification to 'All With Permissions' uses Course Status to filter
* Fix: Deleted users no longer shown on Audits and Reports
* Fix: Ensure course progress bar is correctly displayed once a user is enrolled in a course
* Fix: Ensure only three module tutors are displayed alongside a module
* Fix: Only display the View Certificate button once a course is Completed by the user
* Fix: Syllabus Link on Course Overview caused no longer causes page to jump to the top
* Fix: Cancel button in Module edit returns to either Module Page or Course Module Management
* Fix: Default days for email reminder in Admin Panel can now be set to 0
* Fix: Altered error messages when course/module is missing or an invalid ID is provided
* Fix: Utilise Meow notifications for success/error messages
* Fix: Minor styling issues

## Version 1.7.1 ##
* New Feature: Compatibility with Claromentis 7.2
* Fix: Example Advanced Rule pop-over changed to modal dialog
* Fix: Remove unused localization strings
* Fix: Adjust styling of Group Mode completion selector
* Fix: Check for SCORM package validity during upload
* Fix: Enrolled / Completed users count on course audit displayed incorrectly
* Fix: Adjust the styling and layout of the Admin Preferences page

## Version 1.7 ##
* New Feature: External video providers (Wistia, Bitsontherun) - See README.md for details
* New Feature: Course progression bar
* New Feature: Mandatory Courses (including reporting)
* New Feature: Embedded content with system-wide setting in Admin Panel
* Fix: Module material made mandatory when creating/editing a Module
* Fix: Error when adding a new course when using a MSSQL database

## Version 1.6.1 ##
* Fix: Fixed certificate download bug

## Version 1.6 ##
* New Feature: LMS Homepage Component (LmsComponentDashboard)
* New Feature: LMS Dashboard Page
* New Feature: Congratulations Page
* New Feature: Download PDF Certificate
* Fix: Relaunching completed module won't change module's status back to 'enrolled'
* Fix: Added missing localization

## Version 1.5 ##
* Fix: Compatibility with Claromentis 7.1.3
* Fix: The advanced rules for modules have been extended

## Version 1.4 ##
* New Feature: New report permissions added (View all reports, View reports only from groups to which a user belongs to).
* Fix: Universal tagging for courses fixed (now we can use tag called "any")

## Version 1.3 ##
* New Feature: additional permissions has been added (archive)
* New Feature: reports page now includes more statistics
* New Feature: LMS in social profile
* Fix: icons have been converted to jpg format 
* Fix: notification has been extended

## Version 1.2 ##
* Minor Update

## Version 1.1 ##
* Minor Update

## Version 1.0 ##
* Initial Release
