<?php

use Claromentis\Core\Services;
use Claromentis\Menu\Infobar\MenuItemApplication;
use Claromentis\Menu\Infobar\MenuItemRepository;

if (!defined('INSTALL_PROGRESS'))
	die("This file cannot be executed directly");

if (!isset($installer))
	throw new Exception("Install options are not defined");

/** @var Claromentis\Setup\SetupFacade $installer */
include_once __DIR__ . '/../classes/constants.php';

DBVar::Set(LmsEmailReminder::LMS_EMAIL_REMINDER_LBL, LmsEmailReminder::LMS_EMAIL_REMINDER_DEFAULT);

// Data directories
$DATA_DIR = $installer->GetDataDir();

$dataDirectories = [
	"$DATA_DIR/lms",
	"$DATA_DIR/lms/materials",
	"$DATA_DIR/lms/materials/upload",
	"$DATA_DIR/lms/materials/scorm",
	"$DATA_DIR/lms/materials/video_tmp"
];

foreach ($dataDirectories as $dataDirectory) {
	if (!file_exists($dataDirectory)) {
		mkdir($dataDirectory, 0775, true);
		chmod($dataDirectory, 0775);
	}
}

// Appdata directories
$cdn = Services::I()->GetCDN();

$appdataDirectories = [
	'lms',
	'lms/icons',
	'lms/icons/courses',
	'lms/icons/modules'
];

foreach ($appdataDirectories as $appdataDirectory) {
	if (!$cdn->IsDir($appdataDirectory)) {
		$cdn->CreateDir($appdataDirectory);
	}
}

// Plugin registration
$plugins = $installer->GetPluginsRepository();
$plugins->Add('lms', 'LmsPlugin');

// Admin panel
$admin_panels = $installer->GetAdminPanelCreator();
$admin_panels->Enable('lms');

// Application menu
$menu = Services::I()->{MenuItemRepository::class};
$menu->save(new MenuItemApplication('lms', 'Courses', '/learning/courses/'));
