<?php
$_db_migration_to = '01.02';
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('03_change_reports_permissions.php', <<<'DB_UPDATE_FILE'
<?php

// 720 = PERM_CLASS_LMS_ADMIN_SETTINGS
// 1 = PERM_OBJECT_ADMIN
$perms = new Permissions(720, 1);
$perms->Load();

$old_full_access_to_reports = 4;
$new_full_access_to_reports = 20;

$perms->MovePerms($old_full_access_to_reports,$new_full_access_to_reports);
$perms->save();
DB_UPDATE_FILE
);


$migrations->Run('04_module_advanced_rule_extended.php', <<<'DB_UPDATE_FILE'
<?php

$db->AddColumn('lms_dependency', 'dependency_group', 'INT NOT_NULL DEFAULT 0');
$db->CreateIndex('lms_dependency', 'idx_dependency_group', 'dependency_group');

$q = new Query('SELECT * FROM lms_dependency WHERE aggregation = int:aggregation ORDER BY object_id, id');
$q->Bind('aggregation', 105); // 105 = AGGREGATION_LMS_MODULE

$groups = array();
$result = $db->query($q);
while($row = $result->fetchArray())
{
	if( !array_key_exists($row['object_id'], $groups)) $groups[$row['object_id']] = 0;
	else $groups[$row['object_id']] += 1;

	$group_id = $groups[$row['object_id']];
	if($group_id > 0)
	{
		$update = new QueryUpdate('lms_dependency', 'id = int:id');
		$update->AddColumn('int:dependency_group', $group_id);
		$update->Bind('id', $row['id']);

		$db->query($update);
	}
}
DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('01.02');
