<?php
$_db_migration_to = '11.08'; // 2.5.7
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('01_lmslrs-value-column-to-clob.php', <<<'DB_UPDATE_FILE'
<?php

/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

// Migration to fix truncated SCORM suspended attempt data in BT-2988 DISCO-34658

// change column from varchar(3000) to CLOB
$db->AlterColumn('lms_lrs', 'rec_value', 'rec_value', 'CLOB NULL');

// delete entries for SCORM suspended attempt data where the length is equal to 3000 chars,
// meaning it has almost certainly been truncated and prevent the user from continuing their
// attempt
if ($db->type() == 'mysql')
{
	$db->query("DELETE FROM lms_lrs WHERE rec_key = 'cmi.suspend_data' AND LENGTH(rec_value) >= 3000");
} elseif ($db->type() == 'mssql')
{
	// MSSQL's LEN() function helpfully doesn't work with actual text columns, so
	// we have to use datalength instead which as it's an ascii text column will
	// equate to number of characters.
	$db->query("DELETE FROM lms_lrs WHERE rec_key = 'cmi.suspend_data' AND datalength(rec_value) >= 3000");
}


DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('11.08');
