<?php
// This file contains the database schema version 14.01
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
if ($migrations->GetVersion() > 0)
	throw new Exception("The database is already initialized");
//===========================================================================================

// lms_category
$table_descr = array(
	'id'	=>	"IDENTITY",
	'name'	=>	"VARCHAR(255) NULL",
	'created_by'	=>	"INT NULL",
	'created_date'	=>	"INT_DATE NULL",
	'modified_by'	=>	"INT NULL",
	'modified_date'	=>	"INT_DATE NULL",
);

$db->CreateTable('lms_category', $table_descr, true);



// lms_course
$table_descr = array(
	'id'	=>	"IDENTITY",
	'status'	=>	"INT NOT_NULL DEFAULT 0",
	'title'	=>	"VARCHAR(255) NULL",
	'description'	=>	"VARCHAR_MAX NULL",
	'summary'	=>	"VARCHAR(1000) NULL",
	'prerequisite'	=>	"VARCHAR(1000) NULL",
	'duration'	=>	"VARCHAR(255) NULL",
	'created_by'	=>	"INT NULL",
	'created_date'	=>	"INT_DATE NULL",
	'modified_by'	=>	"INT NULL",
	'modified_date'	=>	"INT_DATE NULL",
	'course_owner'	=>	"INT NOT_NULL DEFAULT 0",
	'qualification_code'	=>	"VARCHAR(255) NULL DEFAULT NULL",
	'has_training_record'	=>	"INT NOT_NULL DEFAULT 0",
	'complete_attempt_validity_interval'	=>	"VARCHAR(128) NULL DEFAULT NULL",
);

$db->CreateTable('lms_course', $table_descr, true);



// lms_course_audit
$table_descr = array(
	'id'	=>	"IDENTITY",
	'course_id'	=>	"INT NOT_NULL",
	'user_id'	=>	"INT NOT_NULL",
	'status'	=>	"INT NOT_NULL DEFAULT 0",
	'date_enrolled'	=>	"INT_DATE NULL",
	'date_completed'	=>	"INT_DATE NULL",
);

$db->CreateTable('lms_course_audit', $table_descr, true);
$db->CreateIndex('lms_course_audit', 'idx_course_id_user_id', 'course_id', 'user_id');



// lms_course_category
$table_descr = array(
	'id'	=>	"IDENTITY",
	'course_id'	=>	"INT NOT_NULL",
	'category_id'	=>	"INT NOT_NULL",
);

$db->CreateTable('lms_course_category', $table_descr, true);
$db->CreateIndex('lms_course_category', 'idx_course_id', 'course_id');
$db->CreateIndex('lms_course_category', 'idx_category_id', 'category_id');



// lms_course_module
$table_descr = array(
	'id'	=>	"IDENTITY",
	'course_id'	=>	"INT NOT_NULL DEFAULT 0",
	'module_id'	=>	"INT NOT_NULL",
	'position'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('lms_course_module', $table_descr, true);
$db->CreateIndex('lms_course_module', 'idx_course_id', 'course_id');
$db->CreateIndex('lms_course_module', 'idx_module_id', 'module_id');



// lms_dependency
$table_descr = array(
	'id'	=>	"IDENTITY",
	'aggregation'	=>	"INT NOT_NULL",
	'object_id'	=>	"INT NOT_NULL",
	'dependent_object_id'	=>	"INT NOT_NULL",
	'dependency_group'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('lms_dependency', $table_descr, true);
$db->CreateIndex('lms_dependency', 'idx_aggre_object_id', 'aggregation', 'object_id');
$db->CreateIndex('lms_dependency', 'idx_dependent_object_id', 'dependent_object_id');
$db->CreateIndex('lms_dependency', 'idx_dependency_group', 'dependency_group');



// lms_lrs
$table_descr = array(
	'id'	=>	"IDENTITY",
	'rec_key'	=>	"VARCHAR(255) NULL",
	'rec_value'	=>	"CLOB NULL",
	'attempt_id'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('lms_lrs', $table_descr, true);
$db->CreateIndex('lms_lrs', 'idx_attempt_id_rec_key', 'attempt_id', 'rec_key(128)');
$db->CreateIndex('lms_lrs', 'idx_rec_key', 'rec_key(128)');
$db->CreateIndex('lms_lrs', 'idx_attempt_id', 'attempt_id');



// lms_lrs_attempts
$table_descr = array(
	'id'	=>	"IDENTITY",
	'attempt'	=>	"INT NOT_NULL DEFAULT 0",
	'user_id'	=>	"INT NOT_NULL DEFAULT 0",
	'module_id'	=>	"INT NOT_NULL DEFAULT 0",
	'created_date'	=>	"INT_DATE NOT_NULL DEFAULT 0",
	'type'	=>	"VARCHAR(10) NULL",
	'complete'	=>	"INT NULL",
);

$db->CreateTable('lms_lrs_attempts', $table_descr, true);
$db->CreateIndex('lms_lrs_attempts', 'idx_user_id_module_id', 'user_id', 'module_id');
$db->CreateIndex('lms_lrs_attempts', 'idx_complete', 'complete');



// lms_material
$table_descr = array(
	'id'	=>	"IDENTITY",
	'module_id'	=>	"INT NOT_NULL",
	'type'	=>	"INT NOT_NULL DEFAULT 0",
	'name'	=>	"VARCHAR(255) NULL",
	'material'	=>	"VARCHAR_MAX NULL",
	'doc_id'	=>	"INT NOT_NULL DEFAULT 0",
	'version'	=>	"INT NOT_NULL DEFAULT 1",
	'created_date'	=>	"INT_DATE NULL",
	'created_by'	=>	"INT NOT_NULL",
);

$db->CreateTable('lms_material', $table_descr, true);
$db->CreateIndex('lms_material', 'idx_module_id', 'module_id');



// lms_module
$table_descr = array(
	'id'	=>	"IDENTITY",
	'status'	=>	"INT NOT_NULL DEFAULT 0",
	'title'	=>	"VARCHAR(255) NULL",
	'description'	=>	"VARCHAR_MAX NULL",
	'note'	=>	"VARCHAR(1000) NULL",
	'type'	=>	"INT NOT_NULL DEFAULT 1",
	'duration'	=>	"VARCHAR(255) NULL",
	'no_access_info'	=>	"VARCHAR_MAX NULL",
	'created_by'	=>	"INT NULL",
	'created_date'	=>	"INT_DATE NULL",
	'modified_by'	=>	"INT NULL",
	'modified_date'	=>	"INT_DATE NULL",
	'module_owner'	=>	"INT NOT_NULL DEFAULT 0",
	'group_mode'	=>	"INT NOT_NULL DEFAULT 0",
	'remainder'	=>	"INT NOT_NULL DEFAULT 0",
	'module_length'	=>	"INT NOT_NULL DEFAULT 0",
	'complete_attempt_validity_interval'	=>	"VARCHAR(128) NULL DEFAULT NULL",
);

$db->CreateTable('lms_module', $table_descr, true);



// lms_module_audit
$table_descr = array(
	'id'	=>	"IDENTITY",
	'module_id'	=>	"INT NOT_NULL",
	'user_id'	=>	"INT NOT_NULL",
	'status'	=>	"INT NOT_NULL DEFAULT 0",
	'date_enrolled'	=>	"INT_DATE NULL",
	'date_completed'	=>	"INT_DATE NULL",
	'score'	=>	"FLOAT NOT_NULL DEFAULT 0",
	'max_score'	=>	"FLOAT NOT_NULL DEFAULT 0",
	'group_head_id'	=>	"INT NOT_NULL DEFAULT 0",
	'no_access'	=>	"INT NOT_NULL DEFAULT 1",
	'last_access'	=>	"INT_DATE NULL",
	'access_key'	=>	"VARCHAR(32) NULL",
	'suspend_data'	=>	"VARCHAR_MAX NULL",
);

$db->CreateTable('lms_module_audit', $table_descr, true);
$db->CreateIndex('lms_module_audit', 'idx_module_id_user_id', 'module_id', 'user_id');
$db->CreateIndex('lms_module_audit', 'idx_access_key', 'access_key');



// lms_tutor
$table_descr = array(
	'id'	=>	"IDENTITY",
	'module_id'	=>	"INT NOT_NULL",
	'tutor_id'	=>	"INT NOT_NULL",
	'expertise'	=>	"VARCHAR(255) NULL",
);

$db->CreateTable('lms_tutor', $table_descr, true);
$db->CreateIndex('lms_tutor', 'idx_module_id', 'module_id');



// lms_video
$table_descr = array(
	'id'	=>	"IDENTITY",
	'module_id'	=>	"INT NOT_NULL",
	'material_id'	=>	"INT NOT_NULL",
	'filename'	=>	"VARCHAR(255) NULL",
	'status'	=>	"INT NOT_NULL DEFAULT 0",
	'video_id'	=>	"VARCHAR(255) NULL",
	'video_width'	=>	"INT NOT_NULL",
	'video_height'	=>	"INT NOT_NULL",
	'created_date'	=>	"INT_DATE NULL",
	'created_by'	=>	"INT NOT_NULL",
	'updated_date'	=>	"INT_DATE NULL",
);

$db->CreateTable('lms_video', $table_descr, true);
$db->CreateIndex('lms_video', 'idx_video_material_id', 'material_id');
$db->CreateIndex('lms_video', 'idx_video_module_id', 'module_id');





//===========================================================================================
$migrations->SetVersion('14.01');
