// Calculate the height of the embed after the material <iframe> has loaded
var embedIframe = document.getElementById('embed-iframe');

if (embedIframe) {
    embedIframe.addEventListener('load', setIframeHeight);

    /**
     * Set the embed iframe's height based on the height of its content.
     */
    function setIframeHeight(event) {
        var iframe = event.target;

        if (event.target) {
            var iframeInnerHeight = iframe.contentDocument.body.offsetHeight;
            iframe.style.height   = iframeInnerHeight + 'px';
        }
    }
}

// Open full screen mode on button press
var openFullScreenButton = document.getElementById('open-full-screen');

if (openFullScreenButton) {
    openFullScreenButton.addEventListener('click', function() {
        setFullScreenMode(true);
    });
}

// Closes full screen mode on click
var closeFullScreenButton = document.getElementById('close-full-screen');

if (closeFullScreenButton) {
    closeFullScreenButton.addEventListener('click', function() {
        setFullScreenMode(false);
    });
}

/**
 * Enable or disable full screen mode for the LMS module material.
 *
 * @param {boolean} enabled - Whether full screen mode should be enabled (`true`) or disabled (`false`).
 */
function setFullScreenMode(enabled) {
    var body = document.body;
    var fullScreenWrapper = document.getElementById('full-screen-wrapper');
    var fullScreenModeClass = 'full-screen-mode';
    var overflowHiddenClass = 'overflow-hidden';

    if (enabled) {
        fullScreenWrapper.classList.add(fullScreenModeClass);
        body.classList.add(overflowHiddenClass);
    } else {
        fullScreenWrapper.classList.remove(fullScreenModeClass);
        body.classList.remove(overflowHiddenClass);
    }
}
