define(['jquery', 'backbone'], function($, Backbone){
	var LMS = LMS || {};

	LMS.init = function() {
		LMS.categoryForm = new LMS.CategoryForm();
		LMS.categories = new LMS.Categories();
		LMS.categoriesView = new LMS.CategoriesView({collection: LMS.categories});
		LMS.categories.fetch();
	};

	LMS.Category = Backbone.Model.extend({
		url: function() {
			return this.isNew() ? "/intranet/rest/lms/category" : "/intranet/rest/lms/category/" + this.get("id");
		}
	});

	LMS.Categories = Backbone.Collection.extend({
		model: LMS.Category,
		url: "/intranet/rest/lms/categories"
	});

	LMS.CategoryForm = Backbone.View.extend({
		el: "#category-form",

		events: {
			"click #add-new-category": "addNew"
		},

		initialize: function() {
			_.bindAll(this, "addNew");
		},

		clear: function() {
			$('#new-category').val('');
		},

		addNew: function() {
			var self = this;
			var cat = $('#new-category').val();
			if(!cat)
			{
				cla.showMessage(lmsg('lms.category.invalid_name'), '', 'info');
				return false;
			}
			LMS.categories.create({
				name: cat
			}, {
				wait: true,
				success: function(model, response){
					self.clear();
					cla.showMessage(lmsg('lms.category.success_added'), '', false);
				},
				error: function(model, response){
					self.clear();
					cla.showMessage(response.responseText, '', 'info');
				}
			});
			return false;
		}
	});

	LMS.CategoriesView = Backbone.View.extend({

		el: "#categories",

		initialize: function() {
			_.bindAll(this, "appendCategory", "reset");
			this.collection.bind("reset", this.reset);
			this.collection.bind("add", this.appendCategory);
			this.collection.bind("appendCategory", this.appendCategory);
		},

		appendCategory: function(categoryModel) {
			this.$el.append(new LMS.CategoryView({model: categoryModel, tagName: 'div'}).render().el);
		},

		reset: function() {
			this.$el.empty();
			this.collection.each(function(n) {
				this.appendCategory(n);
			}, this);
		}
	});

	LMS.CategoryView = Backbone.View.extend({

		events: {
			"click .js-delete": "del",
			"click .js-update": "update"
		},

		initialize: function() {
			_.bindAll(this, "render", "_remove", "del", "update");
			this.model.bind("destroy", this._remove);
		},

		_remove: function() {
			this.remove();
			return false;
		},

		update: function() {
			if(this.model.get('name') == this.$(".category-name").val())
			{
				cla.showMessage(lmsg('lms.category.the_same_name'), '', 'info');
				return false;
			}
			this.model.set({name: this.$(".category-name").val()}).save({}, {error: function(model, response){
				cla.showMessage(response.responseText, '', 'info');
			}, success: function(model, response){
				cla.showMessage(response, '', false);
			}});
			return false;
		},

		del: function(e) {
			this.$('.js-delete').tooltip('hide');
			if(confirm(lmsg('lms.category.confirm_delete')))
			{
				this.model.destroy({error: function(model, response) {
					cla.showMessage(response.responseText, '', 'info');
				}, success: function(model, response){
					cla.showMessage(response, '', false);
				}});
			}
			return false;
		},

		render: function() {
			this.$el.html($("#category").tmpl(this.model.toJSON()));
			return this;
		}
	});

	LMS.init();
});
