
define(['backbone'], function (Backbone) {

	TL.TileListCollection = Backbone.Collection.extend({
		model: TL.Tile,
		hidePagination: false,
		total: 0,

		url: function () {
			if (!TL.settings.collectionURL) {
				throw lmsg('lms.tile.error.missing_collection_url');
			}
			return TL.settings.collectionURL;
		},

		maxID: function () {
			return this.max(function (c) {
				return parseInt(c.get("id"), 10);
			});
		},

		minID: function () {
			return this.min(function (c) {
				return parseInt(c.get("id"), 10);
			});
		},

		loadMore: function () {
			var xdata = {
				before_id: this.minID().get("id"),
				skip: this.models.length
			};
			this.fetch2({data: xdata, add: true, remove: false, reset: false});
		},

		parse: function (data) {
			TL.tileListCollection.total = data.count;
			return data.results;
		},

		fetch2: function (options) {
			if (typeof options !== 'object') {
				options = {};
			}
			var self = this;
			options.success = function (coll, resp) {
				if (options.add) {
					self.trigger('render');
				}
			};
			this.fetch(TL.router.getFilters(options));
		}
	});

	TL.SideFilterCollection = Backbone.Collection.extend({
		model: TL.SideFilter,

		getByVal: function (val) {
			var _v = val || null;
			var filter = this.where({val: _v});

			if (!filter || typeof filter !== 'object') {
				throw lmsg('lms.tile.error.missing_filter');
			}
			return filter[0];
		},

		getActive: function () {
			var models = this.where({active: true});
			if (typeof models === 'object' || models.length === 1) {
				return models[0];
			}
		},

		resetActive: function () {
			this.each(function (filter) {
				filter.set("active", false);
			});
		},

		setActive: function (val) {
			// Let's check if current filter is active
			if (this.getActive() !== undefined && val == this.getActive().get('val')) return false;

			// Reset active value
			this.resetActive();

			// Set this collection active
			this.active = true;

			// Find an element and set active
			this.getByVal(val).set("active", true);
		}
	});

	TL.TagFilterCollection = TL.SideFilterCollection.extend({
		model: TL.SideFilter
	});

	TL.SortFilterCollection = TL.SideFilterCollection.extend({
		model: TL.SideFilter
	});

	TL.TopFilterCollection = TL.SideFilterCollection.extend({
		model: TL.TopFilter
	});

});
