define(['backbone'], function (Backbone) {

	TL.Router = Backbone.Router.extend({

		routes: {
			"": "start",
			":key/:val": "filter"
		},

		initialize: function () {
			// Tile list model
			TL.tileList = new TL.TileList();

			// Tile list collection
			TL.tileListCollection = new TL.TileListCollection();

			// Tile list view
			TL.tileContainerView = new TL.TileContainerView({collection: TL.tileListCollection});

			// Load more button view
			TL.bottomView = new TL.BottomView();

			// Check if there are any filter collections
			if (TL.settings.filters) {

				// Stores all register filters
				TL.filters = {};

				// Register each filter collection
				_.each(TL.settings.filters, function (filter) {

					// Filter Class
					TL.filters[filter._name] = new window.TL[filter._class]();

					// Filter name
					TL.filters[filter._name]._name = filter._name;

					// Filter View
					TL["filterView" + filter._name] = new window.TL[filter.view]({collection: TL.filters[filter._name]});

					// Filter Data
					TL.filters[filter._name].reset(filter._data);
				});

				// Bind routes
				this._bindRoutes();
			}
		},

		bootstrap: function () {
			TL.tileListCollection.reset(TL.tilesBootstrap.results);
			TL.tileListCollection.total = TL.tilesBootstrap.count;
			TL.bottomView.togglePagination();
		},

		start: function () {
			this.bootstrap();
		},

		filter: function (key, val) {
			// Check if clicked filter exists and set it active
			if (TL.filters[key]) TL.filters[key].setActive(val);

			// Iterate through additional arguments coming from the URL and set other filters to be active
			if (arguments[2] && _.size(arguments[2]) > 0) {
				_.each(arguments[2], function (arg, k) {
					if (TL.filters[k]) TL.filters[k].setActive(arg);
				});
			}

			// Fetch data
			TL.tileListCollection.fetch2();
		},

		resetActive: function () {
			if (TL.filters) {
				_.each(TL.filters, function (f) {
					f.active = false;
				});
			}
		},

		getFilters: function (options) {

			if (typeof options !== 'object') {
				options = {};
			}

			var xdata = options.data || {};

			if (TL.filters) {
				_.each(TL.filters, function (f) {
					// Check all active filters
					if (f.active === true) {

						// Get active value from active collection
						var v = f.getActive().get("val");
						xdata[f._name] = v;
					}
				});
			}

			if (TL.filters['keywords']) {
				xdata['keywords'] = this.getKeyword();
			}

			options.data = xdata;
			options.add = options.add !== false;
			options.reset = options.reset !== false;
			options.remove = options.remove !== false;

			return options;
		},

		getKeyword: function () {
			return TL.filters['keywords'].where({key: "keywords"})[0].get("value");
		},

		getHash: function (obj) {
			var hash_map = obj.hash.split('/');
			var hash = obj.hash.split('?');
			hash = hash[0];
			var i = true;
			if (TL.filters) {
				_.each(TL.filters, function (f) {
					if (f.active === true && f._name !== hash_map[1]) {
						if (i) hash += "?";
						else hash += "&";
						i = false;
						hash += f._name + "=" + f.getActive().get("val");
					}
				});
			}
			obj.hash = hash;
		}
	});

	TL.router = new TL.Router();
});