define(['backbone'], function (Backbone) {

	TL.TileContainerView = Backbone.View.extend({
		el: "#ids-list",

		rows: '',

		initialize: function () {
			_.bindAll(this, "appendTile", "reset", "render", "appendHTMLstring");

			this.collection.bind("add", this.appendHTMLstring);
			this.collection.bind("render", this.render);
			this.collection.bind("reset", this.reset);
		},

		appendHTMLstring: function (collection, resp) {
			this.rows = '';
			var self = this;
			_.each(resp.models, function (tileModel) {
				var one = new TL.TileView({model: tileModel}).render().el;
				self.rows += one.innerHTML;
			});
		},

		appendTile: function (tileModel) {
			var one = new TL.TileView({model: tileModel}).render().el;
			this.rows += one.innerHTML;
		},

		render: function () {
			$('#ids-list').html(this.rows);
		},

		reset: function () {
			this.rows = '';

			this.collection.each(function (tileModel) {
				this.appendTile(tileModel);
			}, this);

			this.render();
		}
	});

	TL.TileView = Backbone.View.extend({
		templateID: "#tile",

		render: function () {
			this.$el.html($(this.templateID).tmpl(this.model.toJSON()));
			TL.tileListCollection.bind("all", this.update);
			return this;
		}
	});

	TL.BottomView = Backbone.View.extend({
		el: "#bottom",

		events: {
			"click .show-more": "showMore"
		},

		initialize: function () {
			_.bindAll(this, "update");
			TL.tileListCollection.bind("all", this.update);
		},

		showMore: function () {
			TL.tileListCollection.loadMore();
			return false;
		},

		togglePagination: function () {
			if (TL.tileListCollection.total <= TL.tileListCollection.length) this.$(".show-more").hide();
			else this.$(".show-more").show();
		},

		update: function () {
			this.togglePagination();
		}
	});


	// Side View for an item
	TL.SideFilterView = Backbone.View.extend({
		tagName: "li",
        className : 'nav-item',
		elementId: "#side-filter",

		events: {
			"click": "toggleActive",
			"change": "toggleActive"
		},


		initialize: function () {
			_.bindAll(this, "render");
			this.model.bind('change', this.toggleActive, this);
		},

		render: function () {
			this.$el.html($(this.elementId).tmpl(this.model.toJSON()));
			if (this.model.get('active')) this.toggleActive();
			return this;
		},

		toggleActive: function () {
			if (!this.model.get('active')) this.$el.removeClass('active');
			else this.$el.addClass('active');
		}
	});

	// Side view for a collection
	TL.SideFiltersView = Backbone.View.extend({
		el: "#side-filters",

		initialize: function () {
			_.bindAll(this, "appendFilter", "reset");
			this.collection.bind("reset", this.reset);
		},

		appendFilter: function (model) {
			this.$el.append(model.render().el);
		},

		reset: function () {
			this.$el.empty();
			if (this.collection.length > 0) {
				this.collection.each(function (filterModel) {
					this.appendFilter(this.getModelView(filterModel));
				}, this);
			}
		},

		getModelView: function (filterModel) {
			return new TL.SideFilterView({model: filterModel});
		}
	});

	// Category View for a collection
	TL.CategoryFiltersView = TL.SideFiltersView.extend({
		el: "#category-filters",

		getModelView: function (filterModel) {
			return new TL.SideFilterView({model: filterModel});
		}
	});

	// Tag view for an item
	TL.TagFilterView = TL.SideFilterView.extend({
		tagName: "span",
		elementId: "#tag-filter",

		toggleActive: function () {
			if (!this.model.get('active')) this.$el.find('a').removeClass('active');
			else this.$el.find('a').addClass('active');
		}
	});

	// Tag view for a collection
	TL.TagFiltersView = TL.SideFiltersView.extend({
		el: "#tag-filters",
		getModelView: function (filterModel) {
			return new TL.TagFilterView({model: filterModel});
		}
	});

	// Tag  sort view for an item
	TL.SortFilterView = TL.SideFilterView.extend({
		tagName: "span",
		elementId: "#top-filter-sort",

		toggleActive: function () {
			if (!this.model.get('active')) this.$el.removeClass('active');
			else this.$el.addClass('active');
		}
	});

	// Top sort view for a collection
	TL.SortFiltersView = TL.SideFiltersView.extend({
		el: "#top-filters-sort",
		getModelView: function (filterModel) {
			return new TL.TagFilterView({model: filterModel});
		}
	});

	// Top view for an item
	TL.TopFilterTextView = Backbone.View.extend({
		templateID: "#top-filter-text",

		timer: undefined,

		events: {
			"click .js-filter-btn": "search",
			"submit .js-filter-form": "search"
		},

		initialize: function () {
			_.bindAll(this, "render");
		},

		search: function (e) {
			e.preventDefault();
			this.model.set("value", this.$(".js-filter").val()).set('active', true);

			TL.tileListCollection.fetch2();
			return false;
		},

		render: function () {
			this.$el.html($(this.templateID).tmpl(this.model.toJSON()));
			return this;
		}
	});

	// Top view for a collection
	TL.TopFiltersView = Backbone.View.extend({
		el: "#top-filters",

		viewMap: {
			1: TL.TopFilterTextView
		},

		initialize: function () {
			_.bindAll(this, "appendFilter", "reset");
			this.collection.bind("reset", this.reset);
		},

		appendFilter: function (filterModel) {
			if (!filterModel.get("type") || !this.viewMap[filterModel.get("type")]) {
				throw Error(lmsg('lms.tile.error.unkown_top_filter'));
			}

			this.$el.append(new this.viewMap[filterModel.get("type")]({model: filterModel}).render().el);
		},

		reset: function () {
			this.$el.empty();
			this.collection.each(function (filterModel) {
				this.appendFilter(filterModel);
			}, this);
		}
	});

});
