# Learning Courses

Learning Courses, also known as e-Learning or LMS.

## Compatibility

| LMS version | [Claromentis Core](//gitlab.com/claromentis/product/core) version
| ---         | ---
| v3.0        | v9+
| v2.6        | v8.13
| v2.5        | v8.9+
| v2.4        | v8.7+
| v2.3        | v8.2+
| v2.2        | v8.1+
| v2.1        | v8.0+
| v1.10       | v7.4+
| v1.8        | v7.2+

### Change Log

See [CHANGELOG.md](CHANGELOG.md).

## Configuration

### Background Task

If you are upgrading from an existing version of LMS, you will need to remove any lines from 
/intranet/common/background_custom.php that refer to 'LmsBackground' before continuing.

### Video Providers

LMS supports external video providers allowing many video types to be uploaded to an external system to
handle playback. This allows for the video look and feel to be customised, for analytics to be gathered 
from viewers, as well as having the ability to share the same videos outside of the  Learning Management 
System.

Currently, the following video providers are supported:

* Wistia - http://www.wistia.com
* Longtail Video - Bits on the Run - http://www.longtailvideo.com/

To configure a video provider, you will need to add the following details to the config.php file:

```php
$cfg_LMS_video_provider = "LmsVideoProviderWistia";
```

or

```php
$cfg_LMS_video_provider = "LmsVideoProviderBitsontherun";
```

Along with the needed authentication configuration options:

```php
$cfg_wistia_password = "enterapipasswordhere";
```

or

```php
$cfg_bitsontherun_key = "apikeyhere";
$cfg_bitsontherun_secret = "apisecrethere";
$cfg_bitsontherun_playerid = "playeridhere";
```

## Components

### Dashboard

Displays a list of Courses/Modules for which the logged in User is eligible (including current Status and expected Time to complete).

#### Parameters

* **course_limit** - Limits the number of Courses displayed.
  * Default: 10
* **module_limit** - Limits the number of Modules displayed.
  * Default: 10
* **sort_by** - order by this field.
  * Default: title
  * Options: date_added | title
* **sort_direction** - direction of sort order.
  * Default: asc
  * Options: asc | desc
* **fold_completed** - Don't display any child Modules if the Course is completed. 
  * Default: 0
  * Options: 0 | 1
* **show_more_link** - Displays a "more" link to the LMS Dashboard
  * Default: 0

#### Component code

```html
<component class="LmsComponentDashboard" course_limit="2" module_limit="2" sort_direction="asc" sort_by="title" fold_completed="0" show_more_link="1" />
```
