<?php
$_db_migration_to = '11.01'; // 2.5.0
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('01_update_lms_material_document_id.php', <<<'DB_UPDATE_FILE'
<?php

/** @var Claromentis\Setup\SetupFacade $migrations */

$db = $migrations->GetDb();

$results                            = $db->query("SELECT id, doc_id FROM lms_material WHERE type = 5");
$lms_materials_document_version_ids = [];
while ($row = $results->fetchArray())
{
	$lms_materials_document_version_ids[(int) $row['id']] = (int) $row['doc_id'];
}

$document_version_ids = array_unique($lms_materials_document_version_ids);

if (!empty($document_version_ids))
{
	$results       = $db->query("SELECT id, doc_id FROM ERMS_data WHERE id IN in:int:doc_version_ids", $document_version_ids);
	$documents_ids = [];
	while ($row = $results->fetchArray())
	{
		$documents_ids[(int) $row['id']] = (int) $row['doc_id'];
	}

	foreach ($lms_materials_document_version_ids as $id => $document_version_id)
	{
		if (isset($documents_ids[$document_version_id]))
		{
			$db->query("UPDATE lms_material SET doc_id = '$documents_ids[$document_version_id]' WHERE id = $id");
		} else
		{
			$migrations->Log("Failed to replace Document Version ID '$document_version_id' with Document ID for lms_material record $id");
		}
	}
}

DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('11.01');
